/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2DateTimeAttributeTranscoder
extends AbstractSAML2AttributeTranscoder<DateTimeAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_EPOCH_UNITS = "saml2.epochUnits";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2DateTimeAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof DateTimeAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull DateTimeAttributeValue value) throws AttributeEncodingException {
        Boolean encodeType = (Boolean)rule.getOrDefault("saml2.encodeType", Boolean.class, (Object)Boolean.TRUE);
        return SAMLEncoderSupport.encodeDateTimeValue((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (Instant)value.getValue(), (boolean)encodeType);
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        Instant retVal;
        if (value != null && (retVal = this.getDateTimeValue(rule, value)) != null) {
            return new DateTimeAttributeValue(retVal);
        }
        return null;
    }

    @Nullable
    protected Instant getDateTimeValue(@Nonnull TranscodingRule rule, @Nonnull XMLObject object) {
        XSAny wc;
        Instant retVal = null;
        if (object instanceof XSString) {
            return this.getDateTimeValue(rule, ((XSString)object).getValue());
        }
        if (object instanceof XSInteger && ((XSInteger)object).getValue() != null) {
            return this.getDateTimeValue(rule, ((XSInteger)object).getValue().longValue());
        }
        if (object instanceof XSDateTime) {
            retVal = ((XSDateTime)object).getValue();
        } else if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            return this.getDateTimeValue(rule, wc.getTextContent());
        }
        if (null == retVal) {
            this.log.info("Value of type {} could not be converted", (Object)object.getClass().getSimpleName());
        }
        return retVal;
    }

    @Nullable
    protected Instant getDateTimeValue(@Nonnull TranscodingRule rule, @Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            Long longVal = Long.valueOf(value);
            if (longVal != null) {
                return this.getDateTimeValue(rule, longVal);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            return DOMTypeSupport.stringToInstant((String)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.warn("{} rule unable to process string value as numeric or ISO format", rule.getOrDefault("id", String.class, (Object)"(none)"));
            return null;
        }
    }

    @Nullable
    protected Instant getDateTimeValue(@Nonnull TranscodingRule rule, @Nonnull Long value) {
        String units = (String)rule.getOrDefault(PROP_EPOCH_UNITS, String.class, (Object)"s");
        if ("s".equals(units)) {
            return Instant.ofEpochSecond(value);
        }
        if ("ms".equals(units)) {
            return Instant.ofEpochMilli(value);
        }
        this.log.error("{} rule property {} must be 's' or 'ms'", rule.getOrDefault("id", String.class, (Object)"(none)"), (Object)PROP_EPOCH_UNITS);
        return null;
    }
}

