/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.SAMLEncoderSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ScopedStringAttributeTranscoder
extends AbstractSAML2AttributeTranscoder<ScopedStringAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_TYPE = "saml2.scopeType";
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_ATTR_NAME = "saml2.scopeAttributeName";
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_DELIMITER = "saml2.scopeDelimiter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2ScopedStringAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof ScopedStringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull ScopedStringAttributeValue value) throws AttributeEncodingException {
        String scopeType = (String)rule.getOrDefault(PROP_SCOPE_TYPE, String.class, (Object)"inline");
        if ("attribute".equals(scopeType)) {
            Boolean encodeType = (Boolean)rule.getOrDefault("saml2.encodeType", Boolean.class, (Object)Boolean.FALSE);
            String scopeAttributeName = (String)rule.getOrDefault(PROP_SCOPE_ATTR_NAME, String.class, (Object)"Scope");
            return SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (ScopedStringAttributeValue)value, (String)scopeAttributeName, (boolean)encodeType);
        }
        if ("inline".equals(scopeType)) {
            Boolean encodeType = (Boolean)rule.getOrDefault("saml2.encodeType", Boolean.class, (Object)Boolean.TRUE);
            String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
            return SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (ScopedStringAttributeValue)value, (String)scopeDelimiter, (boolean)encodeType);
        }
        throw new AttributeEncodingException("Invalid scopeType property (must be inline or attribute)");
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable XMLObject value) {
        if (value == null) {
            return null;
        }
        String stringValue = this.getStringValue(value);
        if (null == stringValue) {
            return null;
        }
        String scopeType = (String)rule.getOrDefault(PROP_SCOPE_TYPE, String.class, (Object)"inline");
        if ("attribute".equals(scopeType)) {
            if (value instanceof AttributeExtensibleXMLObject) {
                String scopeValue = ((AttributeExtensibleXMLObject)value).getUnknownAttributes().get((Object)new QName(null, (String)rule.getOrDefault(PROP_SCOPE_ATTR_NAME, String.class, (Object)"Scope")));
                if (scopeValue == null) {
                    this.log.warn("Scope not found in designated XML attribute");
                    return null;
                }
                return ScopedStringAttributeValue.valueOf((String)stringValue, (String)scopeValue);
            }
            this.log.warn("Object does not support required interface to access the scope via XML attribute");
            return null;
        }
        if ("inline".equals(scopeType)) {
            String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
            int offset = stringValue.indexOf(scopeDelimiter);
            if (offset < 0) {
                this.log.warn("Ignoring value with no scope delimiter ({})", (Object)scopeDelimiter);
                return null;
            }
            return ScopedStringAttributeValue.valueOf((String)stringValue.substring(0, offset), (String)stringValue.substring(offset + scopeDelimiter.length()));
        }
        this.log.error("Invalid scopeType property (must be inline or attribute)");
        return null;
    }
}

