/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2StringAttributeTranscoder;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AttributeMappingNodeProcessor
implements MetadataNodeProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeMappingNodeProcessor.class);
    @Nonnull
    private final ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private final AttributeTranscoder<Attribute> defaultTranscoder;

    public AttributeMappingNodeProcessor(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
        this.defaultTranscoder = new SAML2StringAttributeTranscoder();
        try {
            this.defaultTranscoder.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ConstraintViolationException("Error initializing default transcoder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(XMLObject metadataNode) throws FilterException {
        ServiceableComponent component = null;
        try {
            if (metadataNode instanceof AttributeConsumingService) {
                component = this.transcoderRegistry.getServiceableComponent();
                if (component == null) {
                    this.log.error("Attribute transcoding service unavailable");
                } else {
                    this.handleAttributeConsumingService((AttributeTranscoderRegistry)component.getComponent(), (AttributeConsumingService)metadataNode);
                }
            } else if (metadataNode instanceof EntityDescriptor) {
                component = this.transcoderRegistry.getServiceableComponent();
                if (component == null) {
                    this.log.error("Attribute transcoding service unavailable");
                } else {
                    this.handleEntityAttributes((AttributeTranscoderRegistry)component.getComponent(), ((EntityDescriptor)metadataNode).getExtensions());
                    XMLObject parent = metadataNode.getParent();
                    while (parent instanceof EntitiesDescriptor) {
                        this.handleEntityAttributes((AttributeTranscoderRegistry)component.getComponent(), ((EntitiesDescriptor)parent).getExtensions());
                        parent = parent.getParent();
                    }
                }
            }
        }
        finally {
            if (component != null) {
                component.unpinComponent();
            }
        }
    }

    private void handleAttributeConsumingService(@Nonnull AttributeTranscoderRegistry registry, @Nonnull AttributeConsumingService acs) {
        List requestedAttributes = acs.getRequestedAttributes();
        if (null == requestedAttributes || requestedAttributes.isEmpty()) {
            return;
        }
        HashMultimap results = HashMultimap.create();
        for (RequestedAttribute req : requestedAttributes) {
            try {
                this.decodeAttribute(registry.getTranscodingRules((Object)req), req, (Multimap<String, IdPAttribute>)results);
            }
            catch (AttributeDecodingException e) {
                this.log.warn("Error decoding RequestedAttribute '{}'", (Object)req.getName(), (Object)e);
            }
        }
        if (!results.isEmpty()) {
            acs.getObjectMetadata().put((Object)new AttributesMapContainer((Multimap)results));
        }
    }

    private void handleEntityAttributes(@Nonnull AttributeTranscoderRegistry registry, @Nullable Extensions extensions) {
        if (null == extensions) {
            return;
        }
        List entityAttributesList = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        if (null == entityAttributesList || entityAttributesList.isEmpty()) {
            return;
        }
        HashMultimap results = HashMultimap.create();
        for (XMLObject xmlObj : entityAttributesList) {
            if (!(xmlObj instanceof EntityAttributes)) continue;
            EntityAttributes ea = (EntityAttributes)xmlObj;
            for (Attribute attr : ea.getAttributes()) {
                try {
                    List<TranscodingRule> rulesets = registry.getTranscodingRules((Object)attr);
                    if (rulesets.isEmpty() && "urn:oasis:names:tc:SAML:2.0:attrname-format:uri".equals(attr.getNameFormat())) {
                        this.log.trace("Applying default decoding rule for URI-named attribute {}", (Object)attr.getName());
                        HashMap<String, String> rulemap = new HashMap<String, String>();
                        rulemap.put("id", attr.getName());
                        rulemap.put("transcoder", (String)this.defaultTranscoder);
                        rulemap.put("saml2.name", attr.getName());
                        TranscodingRule defaultRule = new TranscodingRule(rulemap);
                        rulesets = Collections.singletonList(defaultRule);
                    }
                    this.decodeAttribute((Collection<TranscodingRule>)rulesets, attr, (Multimap<String, IdPAttribute>)results);
                }
                catch (AttributeDecodingException e) {
                    this.log.warn("Error decoding RequestedAttribute '{}'", (Object)attr.getName(), (Object)e);
                }
            }
        }
        if (!results.isEmpty()) {
            extensions.getParent().getObjectMetadata().put((Object)new AttributesMapContainer((Multimap)results));
        }
    }

    private <T> void decodeAttribute(@Nonnull @NonnullElements Collection<TranscodingRule> rules, @Nonnull T input, @Nonnull @NonnullElements @Live Multimap<String, IdPAttribute> results) throws AttributeDecodingException {
        for (TranscodingRule rule : rules) {
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            IdPAttribute decodedAttribute = transcoder.decode(null, input, rule);
            if (decodedAttribute == null) continue;
            results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
        }
    }
}

