/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.binding.BindingDescriptor;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ThreadSafeAfterInit
public class SpringAwareMessageEncoderFactory
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, MessageEncoder>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringAwareMessageEncoderFactory.class);
    @Nullable
    private ApplicationContext applicationContext;

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    @Nullable
    public MessageEncoder apply(@Nullable ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (this.applicationContext == null) {
            this.log.warn("No Spring ApplicationContext set");
            return null;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.warn("No outbound message context, unable to lookup message encoder");
            return null;
        }
        SAMLBindingContext bindingContext = (SAMLBindingContext)profileRequestContext.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class);
        if (bindingContext == null || bindingContext.getBindingDescriptor() == null || !(bindingContext.getBindingDescriptor() instanceof BindingDescriptor)) {
            this.log.warn("BindingDescriptor was not available, unable to lookup message encoder");
            return null;
        }
        this.log.debug("Looking up message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        BindingDescriptor descriptor = (BindingDescriptor)bindingContext.getBindingDescriptor();
        if (descriptor.getEncoderBeanId() != null) {
            try {
                return (MessageEncoder)this.applicationContext.getBean(descriptor.getEncoderBeanId(), MessageEncoder.class);
            }
            catch (BeansException e) {
                this.log.warn("Error instantiating message encoder from bean ID {}", (Object)descriptor.getEncoderBeanId(), (Object)e);
            }
        }
        this.log.warn("Failed to find a message encoder based on binding URI: {}", (Object)bindingContext.getBindingUri());
        return null;
    }
}

