/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.LibertyConstants;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.openliberty.xmltooling.disco.MetadataAbstract;
import org.openliberty.xmltooling.disco.ProviderID;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.disco.ServiceType;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.soap.wsaddressing.Address;
import org.opensaml.soap.wsaddressing.EndpointReference;
import org.opensaml.soap.wsaddressing.Metadata;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecorateDelegatedAssertion
extends AbstractProfileAction {
    private final Logger log = LoggerFactory.getLogger(DecorateDelegatedAssertion.class);
    private String libertySSOSEndpointURL;
    @Nullable
    private Function<Pair<ProfileRequestContext, HttpServletRequest>, String> libertySSOSEndpointURLLookupStrategy = new LibertySSOSEndpointURLStrategy();
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, DelegationContext> delegationContextLookupStrategy = new ChildContextLookup(DelegationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, List<Assertion>> assertionLookupStrategy = new AssertionStrategy();
    @Nonnull
    private NamedKeyInfoGeneratorManager keyInfoGeneratorManager;
    private DelegationContext delegationContext;
    private List<Assertion> assertions;
    private RelyingPartyContext relyingPartyContext;
    private String responderId;
    private String relyingPartyId;

    public void setLibertySSOSEndpointURL(@Nullable String url) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.libertySSOSEndpointURL = StringSupport.trimOrNull((String)url);
    }

    public void setLibertySSOSEndpointURLLookupStrategy(@Nullable Function<Pair<ProfileRequestContext, HttpServletRequest>, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.libertySSOSEndpointURLLookupStrategy = strategy;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy may not be null");
    }

    public void setDelegationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DelegationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.delegationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DelegationContext lookup strategy may not be null");
    }

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, List<Assertion>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy may not be null");
    }

    public void setKeyInfoGeneratorManager(@Nonnull NamedKeyInfoGeneratorManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyInfoGeneratorManager = (NamedKeyInfoGeneratorManager)Constraint.isNotNull((Object)manager, (String)"NamedKeyInfoGeneratorManager may not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.keyInfoGeneratorManager == null) {
            throw new ComponentInitializationException("KeyInfoGeneratorManager may not be null");
        }
        if (this.libertySSOSEndpointURL == null && this.libertySSOSEndpointURLLookupStrategy == null) {
            throw new ComponentInitializationException("Either Liberty SSOS endpoint URL or its lookup strategy must be non-null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.assertions = this.assertionLookupStrategy.apply(profileRequestContext);
        if (this.assertions == null || this.assertions.isEmpty()) {
            this.log.debug("No Assertions found to decorate, skipping further processing");
            return false;
        }
        if (!this.doPreExecuteDelegationInfo(profileRequestContext)) {
            return false;
        }
        return this.doPreExecuteRelyingParty(profileRequestContext);
    }

    protected boolean doPreExecuteDelegationInfo(@Nonnull ProfileRequestContext profileRequestContext) {
        this.delegationContext = this.delegationContextLookupStrategy.apply(profileRequestContext);
        if (this.delegationContext == null || !this.delegationContext.isIssuingDelegatedAssertion()) {
            this.log.debug("Issuance of delegated was not indicated, skipping assertion decoration");
            return false;
        }
        if (this.delegationContext.getSubjectConfirmationCredentials() == null || this.delegationContext.getSubjectConfirmationCredentials().isEmpty()) {
            this.log.warn("No subject confirmation credentials available in delegation context");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.resolveLibertySSOSEndpointURL(profileRequestContext);
        if (this.libertySSOSEndpointURL == null) {
            this.log.warn("No Liberty SSOS endpoint URL was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected boolean doPreExecuteRelyingParty(@Nonnull ProfileRequestContext profileRequestContext) {
        this.relyingPartyContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyContext == null) {
            this.log.warn("No RelyingPartyContext was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.relyingPartyId = this.relyingPartyContext.getRelyingPartyId();
        if (this.relyingPartyId == null) {
            this.log.warn("No relying party ID was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.responderId = this.relyingPartyContext.getConfiguration().getResponderId(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            this.log.debug("Decorating assertion for use as delegated token");
            this.decorateDelegatedAssertion(profileRequestContext);
        }
        catch (EventException e) {
            if (Objects.equals("proceed", e.getEventID())) {
                this.log.debug("Decoration of Assertion for delegation terminated with explicit proceed signal");
            }
            this.log.warn("Decoration of Assertion for delegation terminated with explicit non-proceed signal", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
        }
    }

    private void resolveLibertySSOSEndpointURL(ProfileRequestContext profileRequestContext) {
        if (this.libertySSOSEndpointURL != null) {
            this.log.debug("Using explicitly configured Liberty SSOS endpoint URL: {}", (Object)this.libertySSOSEndpointURL);
            return;
        }
        if (this.libertySSOSEndpointURLLookupStrategy != null) {
            this.libertySSOSEndpointURL = this.libertySSOSEndpointURLLookupStrategy.apply((Pair<ProfileRequestContext, HttpServletRequest>)new Pair((Object)profileRequestContext, (Object)this.getHttpServletRequest()));
            if (this.libertySSOSEndpointURL != null) {
                this.log.debug("Using Liberty SSOS endpoint URL resolved via strategy: {}", (Object)this.libertySSOSEndpointURL);
                return;
            }
            this.log.debug("Liberty SSOS endpoint URL strategy was unable to resolve a value");
        }
        this.log.debug("No effective Liberty SSOS endpoint URL could be determined");
    }

    private void decorateDelegatedAssertion(@Nonnull ProfileRequestContext requestContext) throws EventException {
        for (Assertion assertion : this.assertions) {
            this.addSAMLPeerSubjectConfirmation(requestContext, assertion);
            this.addIdPAudienceRestriction(requestContext, assertion);
            this.addLibertySSOSEPRAttribute(requestContext, assertion);
        }
    }

    private void addLibertySSOSEPRAttribute(@Nonnull ProfileRequestContext requestContext, @Nonnull Assertion assertion) {
        Attribute attribute = (Attribute)XMLObjectSupport.buildXMLObject((QName)Attribute.DEFAULT_ELEMENT_NAME);
        attribute.setName("urn:liberty:ssos:2006-08");
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        attribute.getAttributeValues().add(this.buildLibertSSOSEPRAttributeValue(requestContext, assertion));
        List attributeStatements = assertion.getAttributeStatements();
        AttributeStatement attributeStatement = null;
        if (attributeStatements.isEmpty()) {
            attributeStatement = (AttributeStatement)XMLObjectSupport.buildXMLObject((QName)AttributeStatement.DEFAULT_ELEMENT_NAME);
            assertion.getAttributeStatements().add(attributeStatement);
        } else {
            attributeStatement = (AttributeStatement)attributeStatements.get(0);
        }
        attributeStatement.getAttributes().add(attribute);
    }

    @Nonnull
    private XMLObject buildLibertSSOSEPRAttributeValue(@Nonnull ProfileRequestContext requestContext, @Nonnull Assertion assertion) {
        Address address = (Address)XMLObjectSupport.buildXMLObject((QName)Address.ELEMENT_NAME);
        address.setURI(this.libertySSOSEndpointURL);
        MetadataAbstract libertyAbstract = (MetadataAbstract)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.DISCO_ABSTRACT_ELEMENT_NAME);
        libertyAbstract.setValue("ID-WSF Single Sign-On Service");
        ServiceType serviceType = (ServiceType)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.DISCO_SERVICE_TYPE_ELEMENT_NAME);
        serviceType.setValue("urn:liberty:ssos:2006-08");
        ProviderID providerID = (ProviderID)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.DISCO_PROVIDERID_ELEMENT_NAME);
        providerID.setValue(this.responderId);
        Framework framework = (Framework)XMLObjectSupport.buildXMLObject((QName)Framework.DEFAULT_ELEMENT_NAME);
        framework.setVersion("2.0");
        SecurityMechID securityMechID = (SecurityMechID)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.DISCO_SECURITY_MECH_ID_ELEMENT_NAME);
        securityMechID.setValue("urn:liberty:security:2005-02:ClientTLS:peerSAMLV2");
        Token token = (Token)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.SECURITY_TOKEN_ELEMENT_NAME);
        token.setUsage("urn:liberty:security:tokenusage:2006-08:SecurityToken");
        token.setRef("#" + assertion.getID());
        SecurityContext securityContext = (SecurityContext)XMLObjectSupport.buildXMLObject((QName)LibertyConstants.DISCO_SECURITY_CONTEXT_ELEMENT_NAME);
        securityContext.getSecurityMechIDs().add(securityMechID);
        securityContext.getTokens().add(token);
        Metadata metadata = (Metadata)XMLObjectSupport.buildXMLObject((QName)Metadata.ELEMENT_NAME);
        metadata.getUnknownXMLObjects().add(libertyAbstract);
        metadata.getUnknownXMLObjects().add(serviceType);
        metadata.getUnknownXMLObjects().add(providerID);
        metadata.getUnknownXMLObjects().add(framework);
        metadata.getUnknownXMLObjects().add(securityContext);
        EndpointReference epr = (EndpointReference)XMLObjectSupport.buildXMLObject((QName)EndpointReference.ELEMENT_NAME);
        epr.setAddress(address);
        epr.setMetadata(metadata);
        XMLObjectBuilder xsAnyBuilder = XMLObjectSupport.getBuilder((QName)XSAny.TYPE_NAME);
        XSAny attributeValue = (XSAny)xsAnyBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        attributeValue.getUnknownXMLObjects().add(epr);
        return attributeValue;
    }

    private void addIdPAudienceRestriction(@Nonnull ProfileRequestContext requestContext, @Nonnull Assertion assertion) {
        SAML2ActionSupport.addConditionsToAssertion((org.opensaml.profile.action.AbstractProfileAction)this, (Assertion)assertion);
        List audienceRestrictions = assertion.getConditions().getAudienceRestrictions();
        AudienceRestriction audienceRestriction = null;
        if (audienceRestrictions.isEmpty()) {
            audienceRestriction = (AudienceRestriction)XMLObjectSupport.buildXMLObject((QName)AudienceRestriction.DEFAULT_ELEMENT_NAME);
            assertion.getConditions().getAudienceRestrictions().add(audienceRestriction);
        } else {
            audienceRestriction = (AudienceRestriction)audienceRestrictions.get(0);
        }
        for (Audience audience : audienceRestriction.getAudiences()) {
            if (!Objects.equals(this.responderId, StringSupport.trimOrNull((String)audience.getURI()))) continue;
            this.log.debug("Local entity ID '{}' already present in assertion AudienceRestriction set, skipping", (Object)this.responderId);
            return;
        }
        Audience idpAudience = (Audience)XMLObjectSupport.buildXMLObject((QName)Audience.DEFAULT_ELEMENT_NAME);
        idpAudience.setURI(this.responderId);
        audienceRestriction.getAudiences().add(idpAudience);
    }

    private void addSAMLPeerSubjectConfirmation(@Nonnull ProfileRequestContext requestContext, @Nonnull Assertion assertion) throws EventException {
        KeyInfoConfirmationDataType scData = (KeyInfoConfirmationDataType)XMLObjectSupport.getBuilder((QName)KeyInfoConfirmationDataType.TYPE_NAME).buildObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME, KeyInfoConfirmationDataType.TYPE_NAME);
        KeyInfoGeneratorManager kigm = this.keyInfoGeneratorManager.getDefaultManager();
        for (Credential cred : this.delegationContext.getSubjectConfirmationCredentials()) {
            KeyInfoGeneratorFactory kigf = kigm.getFactory(cred);
            KeyInfoGenerator kig = kigf.newInstance();
            try {
                KeyInfo keyInfo = kig.generate(cred);
                scData.getKeyInfos().add(keyInfo);
            }
            catch (SecurityException e) {
                this.log.warn("Error generating KeyInfo from peer credential: {}", (Object)e.getMessage());
                throw new EventException("MessageProcessingError", "Error generating KeyInfo from credential", (Throwable)e);
            }
        }
        NameID nameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue(this.relyingPartyId);
        nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        SubjectConfirmation sc = (SubjectConfirmation)XMLObjectSupport.buildXMLObject((QName)SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        sc.setMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        sc.setNameID(nameID);
        sc.setSubjectConfirmationData((SubjectConfirmationData)scData);
        Subject subject = assertion.getSubject();
        if (subject == null) {
            subject = (Subject)XMLObjectSupport.buildXMLObject((QName)Subject.DEFAULT_ELEMENT_NAME);
            assertion.setSubject(subject);
        }
        subject.getSubjectConfirmations().add(sc);
    }

    public static class LibertySSOSEndpointURLStrategy
    implements Function<Pair<ProfileRequestContext, HttpServletRequest>, String> {
        private Logger log = LoggerFactory.getLogger(LibertySSOSEndpointURLStrategy.class);

        @Override
        @Nullable
        public String apply(@Nullable Pair<ProfileRequestContext, HttpServletRequest> input) {
            if (input == null) {
                this.log.debug("Input Pair<ProfileRequestContext,HttpServletRequest> was null");
                return null;
            }
            if (input.getSecond() != null) {
                HttpServletRequest request = (HttpServletRequest)input.getSecond();
                return String.format("https://%s:%s%s", request.getServerName(), "8443", request.getServletContext().getContextPath() + "/profile/IDWSF/SSOS");
            }
            this.log.debug("Input HttpServletRequest was null");
            return null;
        }
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, List<Assertion>> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public List<Assertion> apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    DecorateDelegatedAssertion.this.log.debug("No outbound message found, nothing to decorate");
                    return Collections.emptyList();
                }
                if (outboundMessage instanceof Assertion) {
                    DecorateDelegatedAssertion.this.log.debug("Found Assertion to decorate as outbound message");
                    return Collections.singletonList((Assertion)outboundMessage);
                }
                if (outboundMessage instanceof Response) {
                    Response response = (Response)outboundMessage;
                    if (response.getAssertions().isEmpty()) {
                        DecorateDelegatedAssertion.this.log.debug("Outbound Response contained no Assertions, nothing to decorate");
                        return Collections.emptyList();
                    }
                    for (Assertion assertion : response.getAssertions()) {
                        if (assertion.getAuthnStatements().isEmpty()) continue;
                        DecorateDelegatedAssertion.this.log.debug("Found Assertion with AuthnStatement to decorate in outbound Response");
                        return Collections.singletonList(assertion);
                    }
                    DecorateDelegatedAssertion.this.log.debug("Found no Assertion with AuthnStatement in outbound Response, returning first");
                    return Collections.singletonList((Assertion)response.getAssertions().get(0));
                }
                DecorateDelegatedAssertion.this.log.debug("Found no Assertion to decorate");
                return null;
            }
            DecorateDelegatedAssertion.this.log.debug("Input ProfileRequestContext or outbound MessageContext was null");
            return null;
        }
    }
}

