/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.DelegationRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateDelegationContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateDelegationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> samlMetadataContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, DelegationContext> delegationContextLookupStrategy;
    private DelegationRequest defaultDelegationRequested = DelegationRequest.NOT_REQUESTED;
    @Nonnull
    private CredentialResolver credentialResolver;
    private DelegationRequest delegationRequested;
    private RelyingPartyContext relyingPartyContext;
    private boolean delegationAllowed;
    private String responderId;
    private String relyingPartyId;
    private RoleDescriptor roleDescriptor;
    private AttributeConsumingService attributeConsumingService;
    private List<Credential> confirmationCredentials;

    public PopulateDelegationContext() {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.samlMetadataContextLookupStrategy = new SAMLMetadataContextLookupFunction();
        this.delegationContextLookupStrategy = new ChildContextLookup(DelegationContext.class, true);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy may not be null");
    }

    public void setSAMLMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.samlMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy may not be null");
    }

    public void setDelegationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, DelegationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.delegationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DelegationContext lookup strategy may not be null");
    }

    public void setCredentialResolver(@Nonnull CredentialResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.credentialResolver = (CredentialResolver)Constraint.isNotNull((Object)resolver, (String)"CredentialResolver may not be null");
    }

    @Nonnull
    public DelegationRequest getDefaultDelegationRequested() {
        return this.defaultDelegationRequested;
    }

    public void setDefaultDelegationRequested(@Nonnull DelegationRequest delegationRequest) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultDelegationRequested = (DelegationRequest)Constraint.isNotNull((Object)delegationRequest, (String)"Default DelegationRequest may not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.relyingPartyContextLookupStrategy == null) {
            throw new ComponentInitializationException("RelyingPartyContext lookup strategy may not be null");
        }
        if (this.samlMetadataContextLookupStrategy == null) {
            throw new ComponentInitializationException("SAMLMetadataContext lookup strategy may not be null");
        }
        if (this.credentialResolver == null) {
            throw new ComponentInitializationException("CredentialResolver may not be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.doPreExecuteInbound(profileRequestContext)) {
            return false;
        }
        if (!this.doPreExecuteRelyingParty(profileRequestContext)) {
            return false;
        }
        if (!this.doPreExecuteMetadata(profileRequestContext)) {
            return false;
        }
        this.delegationRequested = this.getDelegationRequested(profileRequestContext);
        if (DelegationRequest.NOT_REQUESTED.equals((Object)this.delegationRequested)) {
            this.log.debug("Issuance of a delegated Assertion is not in effect, skipping further processing");
            return false;
        }
        this.confirmationCredentials = this.resolveConfirmationCredentials(profileRequestContext);
        return true;
    }

    protected boolean doPreExecuteInbound(@Nonnull ProfileRequestContext profileRequestContext) {
        if (profileRequestContext.getInboundMessageContext() == null || profileRequestContext.getInboundMessageContext().getMessage() == null) {
            this.log.warn("No inbound message context or message found");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!(profileRequestContext.getInboundMessageContext().getMessage() instanceof AuthnRequest)) {
            this.log.debug("Request is not a SAML 2 AuthnRequest");
            return false;
        }
        return true;
    }

    protected boolean doPreExecuteRelyingParty(@Nonnull ProfileRequestContext profileRequestContext) {
        this.relyingPartyContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.relyingPartyContext == null) {
            this.log.warn("No RelyingPartyContext was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.relyingPartyId = this.relyingPartyContext.getRelyingPartyId();
        if (this.relyingPartyId == null) {
            this.log.warn("No relying party ID was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!(this.relyingPartyContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration)) {
            this.log.debug("ProfileConfiguration does not support delegation: {}", (Object)this.relyingPartyContext.getProfileConfig().getClass().getName());
            return false;
        }
        BrowserSSOProfileConfiguration config = (BrowserSSOProfileConfiguration)this.relyingPartyContext.getProfileConfig();
        this.delegationAllowed = config.isAllowDelegation(profileRequestContext);
        this.responderId = this.relyingPartyContext.getConfiguration().getResponderId(profileRequestContext);
        return true;
    }

    protected boolean doPreExecuteMetadata(@Nonnull ProfileRequestContext profileRequestContext) {
        SAMLMetadataContext samlMetadataContext = this.samlMetadataContextLookupStrategy.apply(profileRequestContext);
        if (samlMetadataContext == null) {
            this.log.debug("No SAMLMetadataContext was available, skipping further delegation processing");
            return false;
        }
        this.roleDescriptor = samlMetadataContext.getRoleDescriptor();
        if (this.roleDescriptor == null) {
            this.log.debug("No RoleDescriptor was available, skipping further delegation processing");
            return false;
        }
        AttributeConsumingServiceContext acsContext = (AttributeConsumingServiceContext)samlMetadataContext.getSubcontext(AttributeConsumingServiceContext.class);
        if (acsContext != null) {
            this.attributeConsumingService = acsContext.getAttributeConsumingService();
        }
        if (this.attributeConsumingService == null) {
            this.log.debug("No AttributeConsumingService was resolved, won't be able to determine delegation requested status via metadata");
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        switch (this.delegationRequested) {
            case NOT_REQUESTED: {
                this.log.debug("Delegation was not requested");
                break;
            }
            case REQUESTED_OPTIONAL: {
                if (this.delegationAllowed) {
                    this.log.debug("Delegation token issuance was requested (optional) and allowed");
                    if (this.confirmationCredentials == null || this.confirmationCredentials.isEmpty()) {
                        this.log.warn("Issuance of delegated token was indicated, but no confirmation credentials were available, skipping issuance");
                        break;
                    }
                    this.createAndPopulateDelegationContext(profileRequestContext);
                    break;
                }
                this.log.debug("Delegation token issuance was requested (optional), but not allowed, skipping delegated assertion issuance");
                return;
            }
            case REQUESTED_REQUIRED: {
                if (this.delegationAllowed) {
                    this.log.debug("Delegation token issuance was requested (required) and allowed");
                    if (this.confirmationCredentials == null || this.confirmationCredentials.isEmpty()) {
                        this.log.warn("Issuance of delegated token was indicated, but no confirmation credentials were available");
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
                        break;
                    }
                    this.createAndPopulateDelegationContext(profileRequestContext);
                    break;
                }
                this.log.warn("Delegation token issuance was requested (required), but disallowed by policy");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
                break;
            }
            default: {
                this.log.error("Unknown value '{}' for delegation request state", (Object)this.delegationRequested);
            }
        }
    }

    private void createAndPopulateDelegationContext(ProfileRequestContext profileRequestContext) {
        DelegationContext delegationContext = this.delegationContextLookupStrategy.apply(profileRequestContext);
        if (delegationContext == null) {
            this.log.warn("No DelegationContext was available");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
        }
        delegationContext.setIssuingDelegatedAssertion(true);
        delegationContext.setDelegationRequested(this.delegationRequested);
        delegationContext.setSubjectConfirmationCredentials(this.confirmationCredentials);
    }

    private List<Credential> resolveConfirmationCredentials(@Nonnull ProfileRequestContext requestContext) {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new RoleDescriptorCriterion(this.roleDescriptor));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityIdCriterion(this.relyingPartyId));
        ArrayList<Credential> creds = new ArrayList<Credential>();
        try {
            for (Credential cred : this.credentialResolver.resolve((Object)criteriaSet)) {
                if (cred == null) continue;
                creds.add(cred);
            }
            return creds;
        }
        catch (ResolverException e) {
            this.log.warn("Error resolving subject confirmation credentials for relying party: {}", (Object)this.relyingPartyId, (Object)e);
            return null;
        }
    }

    private DelegationRequest getDelegationRequested(@Nonnull ProfileRequestContext requestContext) {
        if (this.isDelegationRequestedByAudience(requestContext)) {
            this.log.debug("Delegation was requested via AuthnRequest Audience, treating as: {}", (Object)DelegationRequest.REQUESTED_REQUIRED);
            return DelegationRequest.REQUESTED_REQUIRED;
        }
        DelegationRequest requestedByMetadata = this.getDelegationRequestedByMetadata(requestContext);
        if (requestedByMetadata != DelegationRequest.NOT_REQUESTED) {
            this.log.debug("Delegation was requested via metadata: {}", (Object)requestedByMetadata);
            return requestedByMetadata;
        }
        this.log.debug("Delegation request was not explicitly indicated, using default value: {}", (Object)this.getDefaultDelegationRequested());
        return this.getDefaultDelegationRequested();
    }

    @Nonnull
    private DelegationRequest getDelegationRequestedByMetadata(@Nonnull ProfileRequestContext requestContext) {
        if (this.attributeConsumingService == null) {
            this.log.debug("No AttributeConsumingService was available");
            return DelegationRequest.NOT_REQUESTED;
        }
        for (RequestedAttribute requestedAttribute : this.attributeConsumingService.getRequestedAttributes()) {
            if (!Objects.equals("urn:liberty:ssos:2006-08", StringSupport.trimOrNull((String)requestedAttribute.getName()))) continue;
            this.log.debug("Saw requested attribute '{}' in metadata AttributeConsumingService for SP: {}", (Object)"urn:liberty:ssos:2006-08", (Object)this.relyingPartyId);
            if (requestedAttribute.isRequired().booleanValue()) {
                this.log.debug("Metadata delegation request attribute indicated it was required");
                return DelegationRequest.REQUESTED_REQUIRED;
            }
            this.log.debug("Metadata delegation request attribute indicated it was NOT required");
            return DelegationRequest.REQUESTED_OPTIONAL;
        }
        return DelegationRequest.NOT_REQUESTED;
    }

    private boolean isDelegationRequestedByAudience(@Nonnull ProfileRequestContext requestContext) {
        if (!(requestContext.getInboundMessageContext().getMessage() instanceof AuthnRequest)) {
            this.log.debug("Inbound SAML message was not an AuthnRequest: {}", (Object)requestContext.getInboundMessageContext().getMessage().getClass().getName());
            return false;
        }
        AuthnRequest authnRequest = (AuthnRequest)requestContext.getInboundMessageContext().getMessage();
        if (authnRequest.getConditions() != null) {
            Conditions conditions = authnRequest.getConditions();
            for (AudienceRestriction ar : conditions.getAudienceRestrictions()) {
                for (Audience audience : ar.getAudiences()) {
                    String audienceValue = StringSupport.trimOrNull((String)audience.getURI());
                    if (!Objects.equals(audienceValue, this.responderId)) continue;
                    this.log.debug("Saw an AuthnRequest/Conditions/AudienceRestriction/Audience with value of '{}'", (Object)this.responderId);
                    return true;
                }
            }
        }
        return false;
    }
}

