/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.soap.SAMLSOAPClientContextBuilder;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPLogoutRequest
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SOAPLogoutRequest.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutRequest> logoutRequestLookupStrategy = new MessageLookup(LogoutRequest.class).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> propagationContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, SAMLEndpointContext> endpointContextLookupStrategy = new ChildContextLookup(SAMLEndpointContext.class, true).compose(new ChildContextLookup(SAMLPeerEntityContext.class, true).compose((Function)new OutboundMessageContextLookup()));
    @NonnullAfterInit
    private SOAPClient soapClient;
    @Nullable
    @NotEmpty
    private String soapPipelineName;
    @Nullable
    private LogoutRequest logoutRequest;
    @Nullable
    private LogoutPropagationContext propagationContext;
    @Nullable
    private SAMLMetadataContext mdContext;
    @Nullable
    private SAMLEndpointContext epContext;

    public void setLogoutRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutRequest lookup strategy cannot be null");
    }

    public void setPropagationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propagationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setEndpointContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLEndpointContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.endpointContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLEndpointContext lookup strategy cannot be null");
    }

    public void setSOAPClient(@Nonnull SOAPClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.soapClient = (SOAPClient)Constraint.isNotNull((Object)client, (String)"SOAPClient cannot be null");
    }

    public void setSOAPPipelineName(@Nullable @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.soapPipelineName = StringSupport.trimOrNull((String)name);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.soapClient == null) {
            throw new ComponentInitializationException("SOAPClient cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.propagationContext = this.propagationContextLookupStrategy.apply(profileRequestContext);
        if (this.propagationContext == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.logoutRequest = this.logoutRequestLookupStrategy.apply(profileRequestContext);
        if (this.logoutRequest == null) {
            this.log.warn("{} No LogoutRequest found to process", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.epContext = this.endpointContextLookupStrategy.apply(profileRequestContext);
        if (this.epContext == null || this.epContext.getEndpoint() == null || this.epContext.getEndpoint().getLocation() == null) {
            this.log.warn("{} No destination endpoint found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.mdContext = this.metadataContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            InOutOperationContext opContext = new SAMLSOAPClientContextBuilder().setOutboundMessage((SAMLObject)this.logoutRequest).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol").setPipelineName(this.soapPipelineName).setSecurityConfigurationProfileId(profileRequestContext.getProfileId()).setPeerRoleDescriptor(this.mdContext != null ? this.mdContext.getRoleDescriptor() : null).build();
            this.logoutRequest.setDestination(this.epContext.getEndpoint().getLocation());
            this.log.debug("{} Executing LogoutRequest over SOAP 1.1 binding to endpoint: {}", (Object)this.getLogPrefix(), (Object)this.logoutRequest.getDestination());
            this.soapClient.send(this.logoutRequest.getDestination(), opContext);
            Object response = opContext.getInboundMessageContext().getMessage();
            if (response == null) {
                throw new MessageException("No response message received");
            }
            if (!(response instanceof LogoutResponse)) {
                throw new MessageException("Message received was not of correct type");
            }
            profileRequestContext.getInboundMessageContext().setMessage(response);
            SAMLBindingContext bctx = (SAMLBindingContext)profileRequestContext.getInboundMessageContext().getSubcontext(SAMLBindingContext.class, true);
            bctx.setBindingDescriptor(((SAMLBindingContext)profileRequestContext.getOutboundMessageContext().getSubcontext(SAMLBindingContext.class)).getBindingDescriptor());
            this.log.debug("{} Processing LogoutResponse received via SOAP 1.1 binding from endpoint: {}", (Object)this.getLogPrefix(), (Object)this.logoutRequest.getDestination());
            this.handleResponse(profileRequestContext, (LogoutResponse)response);
        }
        catch (ClassCastException e) {
            this.log.warn("{} SOAP message payload was not an instance of LogoutResponse", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
        }
        catch (MessageException | SecurityException | SOAPException e) {
            this.log.warn("{} SOAP logout request failed", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }

    private void handleResponse(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull LogoutResponse response) {
        Status status = response.getStatus();
        if (status != null) {
            StatusCode code = status.getStatusCode();
            if (code != null) {
                if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(code.getValue())) {
                    if ((code = code.getStatusCode()) == null || code.getValue() == null || !"urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(code.getValue())) {
                        this.log.debug("{} Logout successful", (Object)this.getLogPrefix());
                        this.propagationContext.setResult(LogoutPropagationContext.Result.Success);
                    } else {
                        this.log.debug("{} Logout partially successful", (Object)this.getLogPrefix());
                    }
                    return;
                }
                this.log.warn("{} LogoutResponse received with status code '{}'", (Object)this.getLogPrefix(), (Object)code.getValue());
            } else {
                this.log.warn("{} LogoutResponse received with no status code", (Object)this.getLogPrefix());
            }
        } else {
            this.log.warn("{} LogoutResponse received with no status", (Object)this.getLogPrefix());
        }
    }
}

