/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareInboundMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrepareInboundMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);
    @Nullable
    private Function<ProfileRequestContext, String> relyingPartyLookupStrategy;
    @Nullable
    private String relyingPartyId;

    public void setLogoutPropagationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutPropContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    public void setRelyingPartyLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyLookupStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.relyingPartyLookupStrategy != null) {
            this.relyingPartyId = this.relyingPartyLookupStrategy.apply(profileRequestContext);
            if (this.relyingPartyId != null) {
                return true;
            }
            this.log.warn("{} No relying party ID returned from lookup function", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        LogoutPropagationContext logoutPropCtx = this.logoutPropContextLookupStrategy.apply(profileRequestContext);
        if (logoutPropCtx == null) {
            this.log.debug("{} No logout propagation context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (logoutPropCtx.getSession() == null || !(logoutPropCtx.getSession() instanceof SAML2SPSession)) {
            this.log.debug("{} Logout propagation context did not contain a SAML2SPSession", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.relyingPartyId = ((SAML2SPSession)logoutPropCtx.getSession()).getId();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setInboundMessageContext(msgCtx);
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.getSubcontext(SAMLPeerEntityContext.class, true);
        peerContext.setEntityId(this.relyingPartyId);
        this.log.debug("{} Initialized inbound context for message to {}", (Object)this.getLogPrefix(), (Object)this.relyingPartyId);
    }
}

