/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML1AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML1ScopedStringAttributeTranscoder;
import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML1ScopedStringAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private XMLObjectBuilder<XSString> stringBuilder;
    private XMLObjectBuilder<ScopedValue> scopedBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<AttributeDesignator> designatorBuilder;
    private static final String ATTR_NAME = "foo";
    private static final String ATTR_NAMESPACE = "Namespace";
    private static final String STRING_1 = "Value The First";
    private static final String STRING_2 = "Second string the value is";
    private static final String SCOPE_1 = "scope1.example.org";
    private static final String SCOPE_2 = "scope2";
    private static final String DELIMITER = "#";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
        this.scopedBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ScopedValue.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.TYPE_NAME);
        this.designatorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeDesignator.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML1ScopedStringAttributeTranscoder transcoder = new SAML1ScopedStringAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML1AttributeTranscoder.NamingFunction())));
        HashMap<String, String> ruleset1 = new HashMap<String, String>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", (String)transcoder);
        ruleset1.put("saml1.name", ATTR_NAME);
        ruleset1.put("saml1.namespace", ATTR_NAMESPACE);
        ruleset1.put("saml1.scopeDelimiter", DELIMITER);
        ruleset1.put("saml1.scopeType", "attribute");
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        AttributeDesignator samlAttribute = (AttributeDesignator)this.designatorBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertFalse((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new StringAttributeValue(STRING_1), new StringAttributeValue("Value The First@scope1.example.org"));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getAttributeName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getAttributeNamespace(), (String)ATTR_NAMESPACE);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof ScopedValue), (String)"Child of result attribute should be a ScopedValue");
        Assert.assertNull((Object)child.getSchemaType(), (String)"xsi:type was set");
        ScopedValue childAsScopedValue = (ScopedValue)child;
        Assert.assertEquals((String)childAsScopedValue.getValue(), (String)STRING_1, (String)"Input equals output");
        Assert.assertEquals((String)childAsScopedValue.getScope(), (String)SCOPE_1, (String)"Input equals output");
    }

    @Test
    public void singleRequested() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        AttributeDesignator attr = (AttributeDesignator)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, AttributeDesignator.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getAttributeName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getAttributeNamespace(), (String)ATTR_NAMESPACE);
    }

    @Test
    public void singleDecode() throws Exception {
        ScopedValue scopedValue = (ScopedValue)this.scopedBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        scopedValue.setScopeAttributeName("Scope");
        scopedValue.setValue(STRING_1);
        scopedValue.setScope(SCOPE_1);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        samlAttribute.getAttributeValues().add(scopedValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        ScopedStringAttributeValue value = (ScopedStringAttributeValue)attr.getValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)STRING_1);
        Assert.assertEquals((String)value.getScope(), (String)SCOPE_1);
    }

    @Test
    public void multi() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new ScopedStringAttributeValue(STRING_2, SCOPE_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)2, (String)"Encoding 2 entries");
        Assert.assertTrue((children.get(0) instanceof ScopedValue && children.get(1) instanceof ScopedValue ? 1 : 0) != 0, (String)"Child of result attribute should be a string");
        ScopedValue child1 = (ScopedValue)children.get(0);
        Assert.assertEquals((Object)child1.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        ScopedValue child2 = (ScopedValue)children.get(1);
        Assert.assertEquals((Object)child2.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        if (child1.getValue().length() == STRING_1.length()) {
            Assert.assertEquals((String)child1.getValue(), (String)STRING_1, (String)"Input matches output");
            Assert.assertEquals((String)child2.getValue(), (String)STRING_2, (String)"Input matches output");
            Assert.assertEquals((String)child1.getScope(), (String)SCOPE_1, (String)"Input matches output");
            Assert.assertEquals((String)child2.getScope(), (String)SCOPE_2, (String)"Input matches output");
        } else if (child1.getValue().length() == STRING_2.length()) {
            Assert.assertEquals((String)child2.getValue(), (String)STRING_1, (String)"Input matches output");
            Assert.assertEquals((String)child1.getValue(), (String)STRING_2, (String)"Input matches output");
            Assert.assertEquals((String)child2.getScope(), (String)SCOPE_1, (String)"Input matches output");
            Assert.assertEquals((String)child1.getScope(), (String)SCOPE_2, (String)"Input matches output");
        } else {
            Assert.fail((String)"Value mismatch");
        }
    }

    @Test
    public void multiDecode() throws Exception {
        ScopedValue scopedValue = (ScopedValue)this.scopedBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        scopedValue.setScopeAttributeName("Scope");
        scopedValue.setValue(STRING_1);
        scopedValue.setScope(SCOPE_1);
        ScopedValue scopedValue2 = (ScopedValue)this.scopedBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        scopedValue2.setScopeAttributeName("Scope");
        scopedValue2.setValue(STRING_2);
        scopedValue2.setScope(SCOPE_2);
        XSString stringValue3 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue3.setValue("Second string the value is@scope2");
        XSString stringValue4 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue4.setValue(STRING_2);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(ATTR_NAME);
        samlAttribute.setAttributeNamespace(ATTR_NAMESPACE);
        samlAttribute.getAttributeValues().add(scopedValue);
        samlAttribute.getAttributeValues().add(scopedValue2);
        samlAttribute.getAttributeValues().add(stringValue3);
        samlAttribute.getAttributeValues().add(stringValue4);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        ScopedStringAttributeValue value1 = (ScopedStringAttributeValue)attr.getValues().get(0);
        ScopedStringAttributeValue value2 = (ScopedStringAttributeValue)attr.getValues().get(1);
        Assert.assertTrue((STRING_1.equals(value1.getValue()) || STRING_1.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((STRING_2.equals(value1.getValue()) || STRING_2.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_1.equals(value1.getScope()) || SCOPE_1.equals(value2.getScope()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_2.equals(value1.getScope()) || SCOPE_2.equals(value2.getScope()) ? 1 : 0) != 0);
    }
}

