/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2ByteAttributeTranscoder;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML2ByteAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private XMLObjectBuilder<XSString> stringBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<RequestedAttribute> reqAttributeBuilder;
    private static final String ATTR_NAME = "foo";
    private static final String ATTR_NAMEFORMAT = "Namespace";
    private static final String ATTR_FRIENDLYNAME = "friendly";
    private static final byte[] BYTE_ARRAY_1 = new byte[]{1, 2, 3, 4, 5};
    private static final byte[] BYTE_ARRAY_2 = new byte[]{4, 3, 2, 1};
    private static final String INVALID_BASE64_TRAILING = "AB==";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.TYPE_NAME);
        this.reqAttributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(RequestedAttribute.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML2ByteAttributeTranscoder transcoder = new SAML2ByteAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML2AttributeTranscoder.NamingFunction())));
        HashMap<String, Object> ruleset1 = new HashMap<String, Object>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", transcoder);
        ruleset1.put("saml2.encodeType", true);
        ruleset1.put("saml2.name", ATTR_NAME);
        ruleset1.put("saml2.nameFormat", ATTR_NAMEFORMAT);
        ruleset1.put("saml2.friendlyName", ATTR_FRIENDLYNAME);
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.getAttributeValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = Arrays.asList(new StringAttributeValue(ATTR_NAME), new ScopedStringAttributeValue(ATTR_NAME, "bar"), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new StringAttributeValue(ATTR_NAME), new ByteAttributeValue(BYTE_ARRAY_1));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSBase64Binary), (String)"Child of result attribute should be a base64Binary");
        XSBase64Binary childAsString = (XSBase64Binary)child;
        byte[] childAsBa = Base64Support.decode((String)childAsString.getValue());
        Assert.assertEquals((byte[])childAsBa, (byte[])BYTE_ARRAY_1, (String)"Input equals output");
    }

    @Test
    public void singleRequested() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new StringAttributeValue(ATTR_NAME), new ByteAttributeValue(BYTE_ARRAY_1));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setRequired(true);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        RequestedAttribute attr = (RequestedAttribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, RequestedAttribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.isRequired());
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSBase64Binary), (String)"Child of result attribute should be a base64Binary");
        XSBase64Binary childAsString = (XSBase64Binary)child;
        byte[] childAsBa = Base64Support.decode((String)childAsString.getValue());
        Assert.assertEquals((byte[])childAsBa, (byte[])BYTE_ARRAY_1, (String)"Input equals output");
    }

    @Test
    public void singleDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(Base64Support.encode((byte[])BYTE_ARRAY_1, (boolean)false));
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((byte[])((ByteAttributeValue)attr.getValues().get(0)).getValue(), (byte[])BYTE_ARRAY_1);
    }

    @Test(expectedExceptions={AttributeDecodingException.class})
    public void badDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue("******");
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
    }

    @Test(expectedExceptions={AttributeDecodingException.class})
    public void badDecodeInvalidBase64() throws AttributeDecodingException {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(INVALID_BASE64_TRAILING);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
    }

    @Test
    public void singleRequestedDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(Base64Support.encode((byte[])BYTE_ARRAY_1, (boolean)false));
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        Assert.assertEquals((byte[])((ByteAttributeValue)attr.getValues().get(0)).getValue(), (byte[])BYTE_ARRAY_1);
    }

    @Test
    public void multi() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(BYTE_ARRAY_1), new ByteAttributeValue(BYTE_ARRAY_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)2, (String)"Encoding three entries");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSBase64Binary), (String)"Child of result attribute should be a base64Binary");
        XSBase64Binary childAsString = (XSBase64Binary)child;
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        byte[] res0 = Base64Support.decode((String)childAsString.getValue());
        child = (XMLObject)children.get(1);
        Assert.assertTrue((boolean)(child instanceof XSBase64Binary), (String)"Child of result attribute should be a base64Binary");
        childAsString = (XSBase64Binary)child;
        byte[] res1 = Base64Support.decode((String)childAsString.getValue());
        if (BYTE_ARRAY_1.length == res0.length) {
            Assert.assertEquals((byte[])BYTE_ARRAY_1, (byte[])res0, (String)"Input matches output");
            Assert.assertEquals((byte[])BYTE_ARRAY_2, (byte[])res1, (String)"Input matches output");
        } else if (BYTE_ARRAY_1.length == res1.length) {
            Assert.assertEquals((byte[])BYTE_ARRAY_1, (byte[])res1, (String)"Input matches output");
            Assert.assertEquals((byte[])BYTE_ARRAY_2, (byte[])res0, (String)"Input matches output");
        } else {
            Assert.assertTrue((BYTE_ARRAY_1.length == res1.length || BYTE_ARRAY_2.length == res1.length ? 1 : 0) != 0, (String)"One of the output's size should match an input size");
        }
    }

    @Test
    public void multiDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue(Base64Support.encode((byte[])BYTE_ARRAY_1, (boolean)false));
        XSString stringValue2 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue2.setValue(Base64Support.encode((byte[])BYTE_ARRAY_2, (boolean)false));
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        samlAttribute.getAttributeValues().add(stringValue2);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        Assert.assertEquals((byte[])((ByteAttributeValue)attr.getValues().get(0)).getValue(), (byte[])BYTE_ARRAY_1);
        Assert.assertEquals((byte[])((ByteAttributeValue)attr.getValues().get(1)).getValue(), (byte[])BYTE_ARRAY_2);
    }
}

