/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2ScopedStringAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SAML2ScopedStringAttributeTranscoderTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private XMLObjectBuilder<XSString> stringBuilder;
    private SAMLObjectBuilder<Attribute> attributeBuilder;
    private SAMLObjectBuilder<RequestedAttribute> reqAttributeBuilder;
    private static final String ATTR_NAME = "foo";
    private static final String ATTR_NAMEFORMAT = "Namespace";
    private static final String ATTR_FRIENDLYNAME = "friendly";
    private static final String STRING_1 = "Value The First";
    private static final String STRING_2 = "Second string the value is";
    private static final String SCOPE_1 = "scope1.example.org";
    private static final String SCOPE_2 = "scope2";
    private static final String DELIMITER = "#";

    @BeforeClass
    public void setUp() throws ComponentInitializationException {
        this.stringBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
        this.attributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.TYPE_NAME);
        this.reqAttributeBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(RequestedAttribute.TYPE_NAME);
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        SAML2ScopedStringAttributeTranscoder transcoder = new SAML2ScopedStringAttributeTranscoder();
        transcoder.initialize();
        this.registry.setNamingRegistry(Collections.singletonList(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractSAML2AttributeTranscoder.NamingFunction())));
        HashMap<String, String> ruleset1 = new HashMap<String, String>();
        ruleset1.put("id", ATTR_NAME);
        ruleset1.put("transcoder", (String)transcoder);
        ruleset1.put("saml2.name", ATTR_NAME);
        ruleset1.put("saml2.nameFormat", ATTR_NAMEFORMAT);
        ruleset1.put("saml2.friendlyName", ATTR_FRIENDLYNAME);
        ruleset1.put("saml2.scopeDelimiter", DELIMITER);
        ruleset1.put("saml2.scopeType", "inline");
        this.registry.setTranscoderRegistry(Collections.singletonList(new TranscodingRule(ruleset1)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
    }

    @AfterClass
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void emptyEncode() throws Exception {
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.getAttributeValues().isEmpty());
    }

    @Test
    public void emptyDecode() throws Exception {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test
    public void emptyRequestedDecode() throws Exception {
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertTrue((boolean)attr.getValues().isEmpty());
    }

    @Test(expectedExceptions={AttributeEncodingException.class})
    public void inappropriate() throws Exception {
        final int[] intArray = new int[]{1, 2, 3, 4};
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new IdPAttributeValue(){

            public Object getNativeValue() {
                return intArray;
            }

            public String getDisplayValue() {
                return intArray.toString();
            }
        });
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
    }

    @Test
    public void single() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new StringAttributeValue(STRING_1), new StringAttributeValue("Value The First@scope1.example.org"));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSString), (String)"Child of result attribute should be a string");
        Assert.assertEquals((Object)child.getSchemaType(), (Object)XSString.TYPE_NAME, (String)"xsi:type was wrong");
        XSString childAsString = (XSString)child;
        Assert.assertEquals((String)childAsString.getValue(), (String)"Value The First#scope1.example.org");
    }

    @Test
    public void singleRequested() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1));
        IdPRequestedAttribute inputAttribute = new IdPRequestedAttribute(ATTR_NAME);
        inputAttribute.setRequired(true);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules((IdPAttribute)inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        RequestedAttribute attr = (RequestedAttribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, (IdPAttribute)inputAttribute, RequestedAttribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getName(), (String)ATTR_NAME);
        Assert.assertEquals((String)attr.getNameFormat(), (String)ATTR_NAMEFORMAT);
        Assert.assertEquals((String)attr.getFriendlyName(), (String)ATTR_FRIENDLYNAME);
        Assert.assertTrue((boolean)attr.isRequired());
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)1, (String)"Encoding one entry");
        XMLObject child = (XMLObject)children.get(0);
        Assert.assertEquals((Object)child.getElementQName(), (Object)AttributeValue.DEFAULT_ELEMENT_NAME, (String)"Attribute Value not inside <AttributeValue/>");
        Assert.assertTrue((boolean)(child instanceof XSString), (String)"Child of result attribute should be a string");
        XSString childAsString = (XSString)child;
        Assert.assertEquals((String)childAsString.getValue(), (String)"Value The First#scope1.example.org");
    }

    @Test
    public void singleDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue("Value The First#scope1.example.org");
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        ScopedStringAttributeValue value = (ScopedStringAttributeValue)attr.getValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)STRING_1);
        Assert.assertEquals((String)value.getScope(), (String)SCOPE_1);
    }

    @Test
    public void singleRequestedDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue("Value The First#scope1.example.org");
        RequestedAttribute samlAttribute = (RequestedAttribute)this.reqAttributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.setIsRequired(Boolean.valueOf(true));
        samlAttribute.getAttributeValues().add(stringValue);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertTrue((boolean)(attr instanceof IdPRequestedAttribute));
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertTrue((boolean)((IdPRequestedAttribute)attr).isRequired());
        Assert.assertEquals((int)attr.getValues().size(), (int)1);
        ScopedStringAttributeValue value = (ScopedStringAttributeValue)attr.getValues().get(0);
        Assert.assertEquals((String)value.getValue(), (String)STRING_1);
        Assert.assertEquals((String)value.getScope(), (String)SCOPE_1);
    }

    @Test
    public void multi() throws Exception {
        List<IdPAttributeValue> values = Arrays.asList(new ByteAttributeValue(new byte[]{1, 2, 3}), new ScopedStringAttributeValue(STRING_1, SCOPE_1), new ScopedStringAttributeValue(STRING_2, SCOPE_2));
        IdPAttribute inputAttribute = new IdPAttribute(ATTR_NAME);
        inputAttribute.setValues(values);
        Collection rulesets = this.registry.getTranscodingRules(inputAttribute, Attribute.class);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        Attribute attr = (Attribute)TranscoderSupport.getTranscoder((TranscodingRule)ruleset).encode(null, inputAttribute, Attribute.class, ruleset);
        Assert.assertNotNull((Object)attr);
        List children = attr.getOrderedChildren();
        Assert.assertEquals((int)children.size(), (int)2, (String)"Encoding 2 entries");
        String s1 = "Value The First#scope1.example.org";
        String s2 = "Second string the value is#scope2";
        for (XMLObject child : children) {
            Assert.assertTrue((boolean)(child instanceof XSString), (String)"Child of result attribute should be a string");
            String childAsString = ((XSString)children.get(0)).getValue();
            Assert.assertTrue(("Value The First#scope1.example.org".equals(childAsString) || "Second string the value is#scope2".equals(childAsString) ? 1 : 0) != 0);
        }
    }

    @Test
    public void multiDecode() throws Exception {
        XSString stringValue = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue.setValue("Value The First#scope1.example.org");
        XSString stringValue2 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue2.setValue("Second string the value is#scope2");
        XSString stringValue3 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue3.setValue("Second string the value is@scope2");
        XSString stringValue4 = (XSString)this.stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        stringValue4.setValue(STRING_2);
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(ATTR_NAME);
        samlAttribute.setNameFormat(ATTR_NAMEFORMAT);
        samlAttribute.getAttributeValues().add(stringValue);
        samlAttribute.getAttributeValues().add(stringValue2);
        samlAttribute.getAttributeValues().add(stringValue3);
        samlAttribute.getAttributeValues().add(stringValue4);
        Collection rulesets = this.registry.getTranscodingRules((Object)samlAttribute);
        Assert.assertEquals((int)rulesets.size(), (int)1);
        TranscodingRule ruleset = (TranscodingRule)rulesets.iterator().next();
        IdPAttribute attr = TranscoderSupport.getTranscoder((TranscodingRule)ruleset).decode(null, (Object)samlAttribute, ruleset);
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((String)attr.getId(), (String)ATTR_NAME);
        Assert.assertEquals((int)attr.getValues().size(), (int)2);
        ScopedStringAttributeValue value1 = (ScopedStringAttributeValue)attr.getValues().get(0);
        ScopedStringAttributeValue value2 = (ScopedStringAttributeValue)attr.getValues().get(1);
        Assert.assertTrue((STRING_1.equals(value1.getValue()) || STRING_1.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((STRING_2.equals(value1.getValue()) || STRING_2.equals(value2.getValue()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_1.equals(value1.getScope()) || SCOPE_1.equals(value2.getScope()) ? 1 : 0) != 0);
        Assert.assertTrue((SCOPE_2.equals(value1.getScope()) || SCOPE_2.equals(value2.getScope()) ? 1 : 0) != 0);
    }
}

