/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import net.shibboleth.ext.spring.config.StringToDurationConverter;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.saml.metadata.impl.AttributeMappingNodeProcessor;
import net.shibboleth.idp.saml.profile.logic.MappedEntityAttributesPredicate;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class EntityAttributesPredicateTest
extends XMLObjectBaseTestCase {
    private String fooEntityID = "http://foo.example.org/shibboleth";
    private String barEntityID = "http://bar.example.org/shibboleth";
    private String bazEntityID = "http://baz.example.org/shibboleth";
    private GenericApplicationContext pendingTeardownContext = null;
    private MetadataResolver resolver = null;

    @BeforeClass
    protected void setUp() throws Exception {
        String mdFileName = "/net/shibboleth/idp/saml/impl/metadata/attribute-mapping-metadata.xml";
        Document mdDoc = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream(mdFileName));
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(mdDoc.getDocumentElement());
        ArrayList<AttributeMappingNodeProcessor> processors = new ArrayList<AttributeMappingNodeProcessor>();
        processors.add(new AttributeMappingNodeProcessor(this.getService()));
        NodeProcessingMetadataFilter nodeFilter = new NodeProcessingMetadataFilter();
        nodeFilter.setNodeProcessors(processors);
        nodeFilter.initialize();
        mdProvider.setMetadataFilter((MetadataFilter)nodeFilter);
        mdProvider.setId("Test");
        mdProvider.initialize();
        this.resolver = mdProvider;
    }

    @AfterClass
    public void tearDownTestContext() {
        if (null == this.pendingTeardownContext) {
            return;
        }
        this.pendingTeardownContext.close();
        this.pendingTeardownContext = null;
    }

    private void setTestContext(GenericApplicationContext context) {
        this.tearDownTestContext();
        this.pendingTeardownContext = context;
    }

    private EntityDescriptor getEntity(String entityID) throws ResolverException {
        return (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)}));
    }

    private ReloadableService<AttributeTranscoderRegistry> getService() {
        GenericApplicationContext context = new GenericApplicationContext();
        this.setTestContext(context);
        context.setDisplayName("ApplicationContext: ");
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        service.setConverters(new HashSet<StringToDurationConverter>(Arrays.asList(new StringToDurationConverter())));
        service.afterPropertiesSet();
        context.getBeanFactory().setConversionService(service.getObject());
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions("/net/shibboleth/idp/saml/impl/metadata/attribute-registry-service.xml");
        context.refresh();
        return (ReloadableService)context.getBean(ReloadableService.class);
    }

    @Test
    public void testSimpleMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag = new EntityAttributesPredicate.Candidate("zorkmids", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        tag.setValues(Collections.singletonList("10"));
        EntityAttributesPredicate predicate = new EntityAttributesPredicate(Collections.singletonList(tag));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testMultiLevelMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag1 = new EntityAttributesPredicate.Candidate("http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        tag1.setValues(Collections.singletonList("http://refeds.org/category/research-and-scholarship"));
        EntityAttributesPredicate.Candidate tag2 = new EntityAttributesPredicate.Candidate("urn:oasis:names:tc:SAML:profiles:subject-id:req", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        tag2.setValues(Collections.singletonList("none"));
        EntityAttributesPredicate predicate = new EntityAttributesPredicate(Arrays.asList(tag1, tag2), false, true);
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testSimpleMatchMapped() throws ResolverException {
        EntityAttributesPredicate.Candidate tag = new EntityAttributesPredicate.Candidate("zorkmids");
        tag.setValues(Collections.singletonList("10"));
        MappedEntityAttributesPredicate predicate = new MappedEntityAttributesPredicate(Collections.singletonList(tag));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testMultiLevelMappedMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag1 = new EntityAttributesPredicate.Candidate("http://macedir.org/entity-category");
        tag1.setValues(Collections.singletonList("http://refeds.org/category/research-and-scholarship"));
        EntityAttributesPredicate.Candidate tag2 = new EntityAttributesPredicate.Candidate("subject-id-req");
        tag2.setValues(Collections.singletonList("none"));
        MappedEntityAttributesPredicate predicate = new MappedEntityAttributesPredicate(Arrays.asList(tag1, tag2), false, true);
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }
}

