/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.DurablePairwiseIdStore;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.impl.PersistentSAML2NameIDGenerator;
import net.shibboleth.idp.saml.nameid.impl.StoredPersistentIdDecoder;
import net.shibboleth.idp.testing.DatabaseTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StoredPersistentIdDecoderTest
extends OpenSAMLInitBaseTestCase {
    private DataSource testSource;
    private ProfileRequestContext prc;
    private PersistentSAML2NameIDGenerator generator;
    private StoredPersistentIdDecoder decoder;

    @BeforeClass
    public void setUpSource() {
        this.testSource = DatabaseTestingSupport.GetMockDataSource((String)"/net/shibboleth/idp/saml/impl/nameid/StoredIdStore.sql", (String)"StoredIDDataConnectorStore");
    }

    @AfterClass
    public void teardown() {
        DatabaseTestingSupport.InitializeDataSource((String)"/net/shibboleth/idp/saml/impl/nameid/DeleteStore.sql", (DataSource)this.testSource);
    }

    @BeforeMethod
    public void setUp() throws SQLException, IOException, ComponentInitializationException {
        JDBCPairwiseIdStore store = new JDBCPairwiseIdStore();
        store.setDataSource(this.testSource);
        store.initialize();
        this.generator = new PersistentSAML2NameIDGenerator();
        this.generator.setId("test");
        this.generator.setPersistentIdStore((PairwiseIdStore)store);
        this.generator.setAttributeSourceIds(Collections.singletonList("SOURCE"));
        this.decoder = new StoredPersistentIdDecoder();
        this.decoder.setId("test");
        this.decoder.setPersistentIdStore((DurablePairwiseIdStore)store);
        this.decoder.initialize();
        this.prc = new RequestContextBuilder().setInboundMessageIssuer("https://sp.example.org/sp").setOutboundMessageIssuer("https://idp.example.org/idp").buildProfileRequestContext();
    }

    @Test
    public void testMissingID() throws Exception {
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        Subject subject = SAML2ActionTestingSupport.buildSubject((String)"foo");
        Assert.assertNull((Object)this.decoder.decode(scc, subject.getNameID()));
    }

    @Test(expectedExceptions={NameDecoderException.class})
    public void testNoQualifiers() throws Exception {
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        Subject subject = SAML2ActionTestingSupport.buildSubject((String)"foo");
        this.decoder.decode(scc, subject.getNameID());
    }

    @Test
    public void testBadQualifier() throws Exception {
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        id.setNameQualifier(null);
        id.setSPNameQualifier(null);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setRequesterId("Bad");
        scc.setResponderId("https://idp.example.org/idp");
        Assert.assertNull((Object)this.decoder.decode(scc, id));
    }

    @Test
    public void testStoredIdDecode() throws Exception {
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"https://sp.example.org/sp");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        String decoded = this.decoder.decode(scc, id);
        Assert.assertEquals((String)decoded, (String)"foo");
    }

    @Test
    public void testAffiliation() throws Exception {
        this.generator.setSPNameQualifier("http://affiliation.org");
        this.generator.initialize();
        ((SubjectContext)this.prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("foo");
        Assert.assertNull((Object)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent"));
        IdPAttribute source = new IdPAttribute("SOURCE");
        source.setValues(Collections.singletonList(new StringAttributeValue("at1-Data")));
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class, true)).setUnfilteredIdPAttributes(Collections.singleton(source));
        NameID id = (NameID)this.generator.generate(this.prc, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertNotNull((Object)id);
        Assert.assertNotNull((Object)id.getValue());
        Assert.assertEquals((String)id.getFormat(), (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        Assert.assertEquals((String)id.getNameQualifier(), (String)"https://idp.example.org/idp");
        Assert.assertEquals((String)id.getSPNameQualifier(), (String)"http://affiliation.org");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        String decoded = this.decoder.decode(scc, id);
        Assert.assertEquals((String)decoded, (String)"foo");
    }
}

