/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.security.Principal;
import java.util.Collections;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.idp.saml.nameid.impl.BaseTransientDecoder;
import net.shibboleth.idp.saml.nameid.impl.NameIDCanonicalization;
import net.shibboleth.idp.saml.nameid.impl.StoredTransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdParameters;
import net.shibboleth.idp.saml.nameid.impl.TransientNameIDDecoder;
import net.shibboleth.idp.saml.nameid.impl.TransientSAML2NameIDGenerator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransientDecoderTest
extends OpenSAMLInitBaseTestCase {
    private static final String RECIPIENT = "TheRecipient";
    private static final String PRINCIPAL = "ThePrincipalName";
    private MemoryStorageService store;

    @BeforeMethod
    void setUp() throws ComponentInitializationException {
        this.store = new MemoryStorageService();
        this.store.setId("test");
        this.store.initialize();
    }

    @Test
    public void testSucess() throws Exception {
        String principalTokenId = new TransientIdParameters(RECIPIENT, PRINCIPAL).encode();
        String id = "THE_ID";
        long expiration = System.currentTimeMillis() + 50000L;
        Assert.assertTrue((boolean)this.store.create("TransientId", "THE_ID", principalTokenId, Long.valueOf(expiration)), (String)"initial store");
        BaseTransientDecoder decoder = new BaseTransientDecoder(){};
        decoder.setId("decoder");
        decoder.setIdStore((StorageService)this.store);
        decoder.initialize();
        Assert.assertEquals((String)decoder.decode("THE_ID", RECIPIENT), (String)PRINCIPAL);
    }

    @Test
    public void testExpired() throws Exception {
        String principalTokenId = new TransientIdParameters(RECIPIENT, PRINCIPAL).encode();
        String id = "THE_ID";
        long expiration = System.currentTimeMillis() - 50000L;
        Assert.assertTrue((boolean)this.store.create("TransientId", "THE_ID", principalTokenId, Long.valueOf(expiration)), (String)"initial store");
        BaseTransientDecoder decoder = new BaseTransientDecoder(){};
        decoder.setId("decoder");
        decoder.setIdStore((StorageService)this.store);
        decoder.initialize();
        Assert.assertNull((Object)decoder.decode("THE_ID", RECIPIENT));
    }

    @Test
    public void testNotFound() throws Exception {
        BaseTransientDecoder decoder = new BaseTransientDecoder(){};
        decoder.setId("decoder");
        decoder.setIdStore((StorageService)this.store);
        decoder.initialize();
        Assert.assertNull((Object)decoder.decode("THE_ID", RECIPIENT));
    }

    @Test(expectedExceptions={NameDecoderException.class})
    public void testBadRecipient() throws Exception {
        String principalTokenId = new TransientIdParameters(RECIPIENT, PRINCIPAL).encode();
        String id = "THE_ID";
        long expiration = System.currentTimeMillis() + 50000L;
        Assert.assertTrue((boolean)this.store.create("TransientId", "THE_ID", principalTokenId, Long.valueOf(expiration)), (String)"initial store");
        BaseTransientDecoder decoder = new BaseTransientDecoder(){};
        decoder.setId("decoder");
        decoder.setIdStore((StorageService)this.store);
        decoder.initialize();
        decoder.decode("THE_ID", PRINCIPAL);
    }

    @Test
    public void decode() throws Exception {
        StoredTransientIdGenerationStrategy strategy = new StoredTransientIdGenerationStrategy();
        strategy.setId("strategy");
        strategy.setIdStore((StorageService)this.store);
        strategy.initialize();
        TransientSAML2NameIDGenerator generator = new TransientSAML2NameIDGenerator();
        generator.setId("id");
        generator.setTransientIdGenerator((TransientIdGenerationStrategy)strategy);
        generator.initialize();
        ProfileRequestContext prc = new RequestContextBuilder().setInboundMessageIssuer("https://sp.example.org/sp").buildProfileRequestContext();
        ((SubjectContext)prc.getSubcontext(SubjectContext.class, true)).setPrincipalName("PETER_THE_PRINCIPAL");
        NameID nameid = (NameID)generator.generate(prc, generator.getFormat());
        NameIDCanonicalizationFlowDescriptor descriptor = new NameIDCanonicalizationFlowDescriptor();
        descriptor.setFormats(Collections.singleton(generator.getFormat()));
        descriptor.setId("NameIdFlowDescriptor");
        descriptor.initialize();
        NameIDCanonicalization canon = new NameIDCanonicalization();
        TransientNameIDDecoder decoder = new TransientNameIDDecoder();
        decoder.setId("decoder");
        decoder.setIdStore((StorageService)this.store);
        decoder.initialize();
        canon.setDecoder((NameIDDecoder)decoder);
        canon.initialize();
        prc = new ProfileRequestContext();
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)prc.getSubcontext(SubjectCanonicalizationContext.class, true);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NameIDPrincipal(nameid));
        scc.setSubject(subject);
        scc.setAttemptedFlow((SubjectCanonicalizationFlowDescriptor)descriptor);
        scc.setRequesterId("https://sp.example.org/sp");
        scc.setResponderId("https://idp.example.org/idp");
        canon.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertEquals((String)scc.getPrincipalName(), (String)"PETER_THE_PRINCIPAL");
    }
}

