/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.profile.impl.ExtractSubjectFromRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.profile.logic.DefaultNameIDPolicyPredicate;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractSubjectFromRequestTest
extends XMLObjectBaseTestCase {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private ExtractSubjectFromRequest action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        DefaultNameIDPolicyPredicate nameIDPolicyPredicate = new DefaultNameIDPolicyPredicate();
        nameIDPolicyPredicate.setRequesterIdLookupStrategy((Function)new RelyingPartyIdLookupFunction());
        nameIDPolicyPredicate.setResponderIdLookupStrategy((Function)new ResponderIdLookupFunction());
        nameIDPolicyPredicate.setObjectLookupStrategy((Function)new ExtractSubjectFromRequest.SubjectNameLookupFunction());
        nameIDPolicyPredicate.initialize();
        this.action = new ExtractSubjectFromRequest();
        this.action.setNameIDPolicyPredicate((Predicate)nameIDPolicyPredicate);
        this.action.initialize();
    }

    @Test
    public void testNoInboundContext() {
        this.prc.setInboundMessageContext(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoSubject");
    }

    @Test
    public void testNoMessage() {
        this.prc.getInboundMessageContext().setMessage(null);
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoSubject");
    }

    @Test
    public void testNoSubject() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest());
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoSubject");
    }

    @Test
    public void testSAML2Subject() {
        AuthnRequest request = SAML2ActionTestingSupport.buildAuthnRequest();
        request.setSubject(SAML2ActionTestingSupport.buildSubject((String)"foo"));
        this.prc.getInboundMessageContext().setMessage((Object)request);
        request.getSubject().getNameID().setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        request.getSubject().getNameID().setNameQualifier("foo");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        request.getSubject().getNameID().setNameQualifier("http://idp.example.org");
        request.getSubject().getNameID().setSPNameQualifier("foo");
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        request.getSubject().getNameID().setSPNameQualifier("http://sp.example.org");
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNotNull((Object)scc);
        Assert.assertEquals((int)scc.getSubject().getPrincipals(NameIDPrincipal.class).size(), (int)1);
        NameIDPrincipal princ = scc.getSubject().getPrincipals(NameIDPrincipal.class).iterator().next();
        Assert.assertEquals((String)princ.getNameID().getValue(), (String)"foo");
    }

    @Test
    public void testSAML1Subject() {
        Request request = SAML1ActionTestingSupport.buildAttributeQueryRequest((Subject)SAML1ActionTestingSupport.buildSubject((String)"foo"));
        this.prc.getInboundMessageContext().setMessage((Object)request);
        request.getAttributeQuery().getSubject().getNameIdentifier().setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        request.getAttributeQuery().getSubject().getNameIdentifier().setNameQualifier("foo");
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        request.getAttributeQuery().getSubject().getNameIdentifier().setNameQualifier("http://idp.example.org");
        event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        Assert.assertNotNull((Object)scc);
        Assert.assertEquals((int)scc.getSubject().getPrincipals(NameIdentifierPrincipal.class).size(), (int)1);
        NameIdentifierPrincipal princ = scc.getSubject().getPrincipals(NameIdentifierPrincipal.class).iterator().next();
        Assert.assertEquals((String)princ.getNameIdentifier().getValue(), (String)"foo");
    }
}

