/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Predicates;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.idp.saml.profile.impl.InitializeAuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeAuthenticationContextTest
extends OpenSAMLInitBaseTestCase {
    private InitializeAuthenticationContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new InitializeAuthenticationContext();
        this.action.setProxyCountLookupStrategy(FunctionSupport.constant((Object)1));
        this.action.initialize();
    }

    @Test
    public void testNoInboundMessageContext() throws ComponentInitializationException {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        prc.setInboundMessageContext(null);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertFalse((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)1);
    }

    @Test
    public void testNoInboundMessage() throws ComponentInitializationException {
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage(null).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertFalse((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)1);
    }

    @Test
    public void testSAML1AuthnRequest() throws ComponentInitializationException {
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)new IdPInitiatedSSORequest("https://sp.example.org/sp", null, null, null)).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertFalse((boolean)authnCtx.isForceAuthn());
        Assert.assertFalse((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)1);
    }

    @Test
    public void testCreateAuthenticationContext() throws ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.setIsPassive(Boolean.valueOf(true));
        authnRequest.setForceAuthn(Boolean.valueOf(true));
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)authnRequest).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertTrue((boolean)authnCtx.isForceAuthn());
        Assert.assertTrue((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)1);
    }

    @Test
    public void testScopingIgnored() throws ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.setIsPassive(Boolean.valueOf(true));
        authnRequest.setForceAuthn(Boolean.valueOf(true));
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)authnRequest).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Scoping scoping = SAML2ActionTestingSupport.buildScoping((Integer)0, null);
        ((AuthnRequest)prc.getInboundMessageContext().getMessage()).setScoping(scoping);
        this.action = new InitializeAuthenticationContext();
        this.action.setProxyCountLookupStrategy(FunctionSupport.constant((Object)1));
        this.action.setIgnoreScopingPredicate((Predicate)Predicates.alwaysTrue());
        this.action.initialize();
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNotNull((Object)authnCtx);
        Assert.assertTrue((boolean)authnCtx.isForceAuthn());
        Assert.assertTrue((boolean)authnCtx.isPassive());
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)1);
    }

    @Test
    public void testScopingDisallowed() throws ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.setIsPassive(Boolean.valueOf(true));
        authnRequest.setForceAuthn(Boolean.valueOf(true));
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)authnRequest).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Scoping scoping = SAML2ActionTestingSupport.buildScoping((Integer)0, null);
        ((AuthnRequest)prc.getInboundMessageContext().getMessage()).setScoping(scoping);
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setDisallowedFeatures(2);
        ((RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true)).setProfileConfig((ProfileConfiguration)config);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"AccessDenied");
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertNull((Object)authnCtx);
    }

    @Test
    public void testProxyCount() throws ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.setIsPassive(Boolean.valueOf(true));
        authnRequest.setForceAuthn(Boolean.valueOf(true));
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)authnRequest).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Scoping scoping = SAML2ActionTestingSupport.buildScoping((Integer)0, null);
        ((AuthnRequest)prc.getInboundMessageContext().getMessage()).setScoping(scoping);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)0);
    }

    @Test
    public void testProxyList() throws ComponentInitializationException {
        AuthnRequest authnRequest = SAML2ActionTestingSupport.buildAuthnRequest();
        authnRequest.setIsPassive(Boolean.valueOf(true));
        authnRequest.setForceAuthn(Boolean.valueOf(true));
        RequestContext requestCtx = new RequestContextBuilder().setInboundMessage((Object)authnRequest).buildRequestContext();
        ProfileRequestContext prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        Scoping scoping = SAML2ActionTestingSupport.buildScoping((Integer)0, Set.of("foo", "bar"));
        ((AuthnRequest)prc.getInboundMessageContext().getMessage()).setScoping(scoping);
        Event event = this.action.execute(requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        Assert.assertEquals((Object)authnCtx.getProxyCount(), (Object)0);
        Assert.assertEquals((Set)authnCtx.getProxiableAuthorities(), Set.of("foo", "bar"));
    }
}

