/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.InitializeOutboundMessageContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeOutboundMessageContextTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private Request attributeQuery;
    private InitializeOutboundMessageContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.attributeQuery = SAML1ActionTestingSupport.buildAttributeQueryRequest((Subject)SAML1ActionTestingSupport.buildSubject((String)"jdoe"));
        this.src = new RequestContextBuilder().setInboundMessage((Object)this.attributeQuery).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.setOutboundMessageContext(null);
        this.action = new InitializeOutboundMessageContext();
        this.action.initialize();
    }

    @Test
    public void testNoRelyingPartyContext() {
        this.prc.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext());
    }

    @Test
    public void testNoPeerEntityContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
        Assert.assertNull((Object)this.prc.getOutboundMessageContext());
    }

    @Test
    public void testPeerEntityContextNoIssuer() {
        SAMLPeerEntityContext ctx = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyIdContextTree((BaseContext)ctx);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        ctx = (SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertNull((Object)ctx.getEntityId());
    }

    @Test
    public void testPeerEntityContextIssuer() {
        SAMLPeerEntityContext ctx = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setRelyingPartyIdContextTree((BaseContext)ctx);
        this.attributeQuery.getAttributeQuery().setResource("issuer");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.prc.getOutboundMessageContext());
        ctx = (SAMLPeerEntityContext)this.prc.getOutboundMessageContext().getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((String)ctx.getEntityId(), (String)"issuer");
    }
}

