/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.impl.InitializeRelyingPartyContextFromSAMLPeer;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeRelyingPartyContextFromSAMLPeerTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private InitializeRelyingPartyContextFromSAMLPeer action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action = new InitializeRelyingPartyContextFromSAMLPeer();
        this.action.initialize();
    }

    @Test
    public void testNoPeerContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testPeerContext() {
        SAMLPeerEntityContext peer = (SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true);
        peer.setEntityId("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        RelyingPartyContext rp = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        Assert.assertNotNull((Object)rp);
        Assert.assertSame((Object)rp.getRelyingPartyIdContextTree(), (Object)peer);
        Assert.assertEquals((String)rp.getRelyingPartyId(), (String)"foo");
    }
}

