/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.AddDelegationPolicyToAssertion;
import net.shibboleth.idp.saml.xmlobject.DelegationPolicy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Advice;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddDelegationPolicyToAssertionTest
extends OpenSAMLInitBaseTestCase {
    private AddDelegationPolicyToAssertion action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private BrowserSSOProfileConfiguration browserSSOProfileConfig;
    private List<ProfileConfiguration> profileConfigs;
    private Assertion delegatedAssertion;
    private Assertion assertionToModify;
    private Long expectedProfileChainLength = 3L;
    private Long expectedInboundChainLength = 5L;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.assertionToModify = SAML2ActionTestingSupport.buildAssertion();
        this.assertionToModify.getAuthnStatements().add(SAML2ActionTestingSupport.buildAuthnStatement());
        response.getAssertions().add(this.assertionToModify);
        this.browserSSOProfileConfig = new BrowserSSOProfileConfiguration();
        this.browserSSOProfileConfig.setMaximumTokenDelegationChainLength(this.expectedProfileChainLength.longValue());
        this.profileConfigs = new ArrayList<ProfileConfiguration>();
        this.profileConfigs.add((ProfileConfiguration)this.browserSSOProfileConfig);
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).setRelyingPartyProfileConfigurations(this.profileConfigs).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedAssertion.setAdvice((Advice)XMLObjectSupport.buildXMLObject((QName)Advice.DEFAULT_ELEMENT_NAME));
        DelegationPolicy delPolicy = (DelegationPolicy)XMLObjectSupport.buildXMLObject((QName)DelegationPolicy.DEFAULT_ELEMENT_NAME);
        delPolicy.setMaximumTokenDelegationChainLength(this.expectedInboundChainLength);
        this.delegatedAssertion.getAdvice().getChildren().add(delPolicy);
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        this.action = new AddDelegationPolicyToAssertion();
    }

    @Test
    public void testChainLengthFromProfileConfig() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)this.expectedProfileChainLength);
    }

    @Test
    public void testNoRelyingPartyContext() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.prc.removeSubcontext(RelyingPartyContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)AddDelegationPolicyToAssertion.DEFAULT_POLICY_MAX_CHAIN_LENGTH);
    }

    @Test
    public void testNoProfileConfig() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)AddDelegationPolicyToAssertion.DEFAULT_POLICY_MAX_CHAIN_LENGTH);
    }

    @Test
    public void testChainLengthFromDelegatedAssertion() throws ComponentInitializationException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)this.expectedInboundChainLength);
    }

    @Test
    public void testNoDelegatedAssertion() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)this.expectedProfileChainLength);
    }

    @Test
    public void testNoDelegatedAssertionAdvice() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).getAttestedToken().setAdvice(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)AddDelegationPolicyToAssertion.DEFAULT_POLICY_MAX_CHAIN_LENGTH);
    }

    @Test
    public void testNoDelegatedAssertionPolicy() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).getAttestedToken().getAdvice().getChildren().clear();
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((Object)this.getOutboundChainLength(), (Object)AddDelegationPolicyToAssertion.DEFAULT_POLICY_MAX_CHAIN_LENGTH);
    }

    @Test
    public void testActivationCondition() throws ComponentInitializationException {
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertNull((Object)this.getOutboundChainLength());
    }

    @Test
    public void testNoAssertionsToModify() throws ComponentInitializationException {
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().clear();
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertNull((Object)this.getOutboundChainLength());
    }

    private Long getOutboundChainLength() {
        List policies;
        Advice advice = this.assertionToModify.getAdvice();
        if (advice != null && (policies = advice.getChildren(DelegationPolicy.DEFAULT_ELEMENT_NAME)) != null && !policies.isEmpty()) {
            Assert.assertEquals((int)policies.size(), (int)1);
            return ((DelegationPolicy)policies.get(0)).getMaximumTokenDelegationChainLength();
        }
        return null;
    }
}

