/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.AddDelegationRestrictionToAssertions;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddDelegationRestrictionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private AddDelegationRestrictionToAssertions action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private Assertion delegatedAssertion;
    private String delegatedConfirmationMethod;
    private DelegationRestrictionType delegatedRestrictionsCondition;
    private String[] initialDelegates = new String[]{"http:/foo.example.org", "http://bar.example.org", "http://baz.exqmple.org"};
    private String presenterEntityID = "http://portal.example.org";

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedRestrictionsCondition = (DelegationRestrictionType)XMLObjectSupport.getBuilder((QName)DelegationRestrictionType.TYPE_NAME).buildObject(Condition.DEFAULT_ELEMENT_NAME, DelegationRestrictionType.TYPE_NAME);
        for (String entityID : this.initialDelegates) {
            Delegate delegate = (Delegate)XMLObjectSupport.buildXMLObject((QName)Delegate.DEFAULT_ELEMENT_NAME);
            delegate.setNameID(SAML2ActionTestingSupport.buildNameID((String)entityID));
            this.delegatedRestrictionsCondition.getDelegates().add(delegate);
        }
        this.delegatedAssertion.setConditions((Conditions)XMLObjectSupport.buildXMLObject((QName)Conditions.DEFAULT_ELEMENT_NAME));
        this.delegatedAssertion.getConditions().getConditions().add(this.delegatedRestrictionsCondition);
        this.delegatedConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedToken(this.delegatedAssertion);
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class, true)).setAttestedSubjectConfirmationMethod(this.delegatedConfirmationMethod);
        ((SAMLPresenterEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPresenterEntityContext.class, true)).setEntityId(this.presenterEntityID);
        this.action = new AddDelegationRestrictionToAssertions();
    }

    @Test
    public void testSuccessCloneExistingDelegates() throws ComponentInitializationException, MarshallingException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((int)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().size(), (int)1);
        Assertion newAssertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Assert.assertNotNull((Object)newAssertion.getConditions());
        List<DelegationRestrictionType> drts = this.getDelegationRestrictionConditions(newAssertion.getConditions());
        Assert.assertEquals((int)drts.size(), (int)1);
        DelegationRestrictionType drt = drts.get(0);
        Assert.assertEquals((int)drt.getDelegates().size(), (int)(this.initialDelegates.length + 1));
        Delegate newDelegate = (Delegate)drt.getDelegates().get(this.initialDelegates.length);
        Assert.assertNotNull((Object)newDelegate.getNameID());
        Assert.assertEquals((String)newDelegate.getNameID().getValue(), (String)this.presenterEntityID);
        Assert.assertNotNull((Object)newDelegate.getConfirmationMethod());
        Assert.assertEquals((String)newDelegate.getConfirmationMethod(), (String)this.delegatedConfirmationMethod);
        Assert.assertNotNull((Object)newDelegate.getDelegationInstant());
    }

    @Test
    public void testSuccessNoExistingDelegates() throws ComponentInitializationException, MarshallingException {
        this.delegatedAssertion.setConditions(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        Assert.assertEquals((int)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().size(), (int)1);
        Assertion newAssertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        Assert.assertNotNull((Object)newAssertion.getConditions());
        List<DelegationRestrictionType> drts = this.getDelegationRestrictionConditions(newAssertion.getConditions());
        Assert.assertEquals((int)drts.size(), (int)1);
        DelegationRestrictionType drt = drts.get(0);
        Assert.assertEquals((int)drt.getDelegates().size(), (int)1);
        Delegate newDelegate = (Delegate)drt.getDelegates().get(0);
        Assert.assertNotNull((Object)newDelegate.getNameID());
        Assert.assertEquals((String)newDelegate.getNameID().getValue(), (String)this.presenterEntityID);
        Assert.assertNotNull((Object)newDelegate.getConfirmationMethod());
        Assert.assertEquals((String)newDelegate.getConfirmationMethod(), (String)this.delegatedConfirmationMethod);
        Assert.assertNotNull((Object)newDelegate.getDelegationInstant());
    }

    @Test
    public void testActivationCondition() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testNoAssertionsToModify() throws ComponentInitializationException {
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().clear();
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
    }

    @Test
    public void testNoResponse() throws ComponentInitializationException {
        this.prc.getOutboundMessageContext().setMessage(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoLibertyContext() throws ComponentInitializationException {
        this.prc.removeSubcontext(LibertySSOSContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoDelegatedAssertion() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).setAttestedToken(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoDelegatedConfirmationMethod() throws ComponentInitializationException {
        ((LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class)).setAttestedSubjectConfirmationMethod(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoPresenter() throws ComponentInitializationException {
        this.prc.getInboundMessageContext().removeSubcontext(SAMLPresenterEntityContext.class);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoPresenterEntityID() throws ComponentInitializationException {
        ((SAMLPresenterEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPresenterEntityContext.class)).setEntityId(null);
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"InvalidProfileContext");
    }

    private List<DelegationRestrictionType> getDelegationRestrictionConditions(Conditions conditions) {
        ArrayList<DelegationRestrictionType> drts = new ArrayList<DelegationRestrictionType>();
        for (Condition conditionChild : conditions.getConditions()) {
            if (!DelegationRestrictionType.TYPE_NAME.equals(conditionChild.getSchemaType()) || !(conditionChild instanceof DelegationRestrictionType)) continue;
            drts.add((DelegationRestrictionType)conditionChild);
        }
        return drts;
    }
}

