/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.impl;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.delegation.LibertySSOSContext;
import net.shibboleth.idp.saml.saml2.profile.delegation.impl.PopulateLibertyContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.wssecurity.SAML20AssertionToken;
import org.opensaml.soap.wssecurity.messaging.Token;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateLibertyContextTest
extends OpenSAMLInitBaseTestCase {
    private PopulateLibertyContext action;
    private RequestContext rc;
    private ProfileRequestContext prc;
    private SAML20AssertionToken delegatedToken;
    private Assertion delegatedAssertion;
    private String delegatedConfirmationMethod;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.rc = new RequestContextBuilder().setInboundMessage((Object)SAML2ActionTestingSupport.buildAuthnRequest()).setOutboundMessage((Object)response).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        Assertion dummyAssertion = SAML2ActionTestingSupport.buildAssertion();
        dummyAssertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"neo"));
        SubjectConfirmation dummyConfirmation = (SubjectConfirmation)XMLObjectSupport.buildXMLObject((QName)SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        dummyConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        dummyAssertion.getSubject().getSubjectConfirmations().add(dummyConfirmation);
        this.delegatedConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        this.delegatedAssertion = SAML2ActionTestingSupport.buildAssertion();
        this.delegatedAssertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"morpheus"));
        SubjectConfirmation delegatedConfirmation = (SubjectConfirmation)XMLObjectSupport.buildXMLObject((QName)SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        delegatedConfirmation.setMethod(this.delegatedConfirmationMethod);
        this.delegatedAssertion.getSubject().getSubjectConfirmations().add(delegatedConfirmation);
        WSSecurityContext wssContext = (WSSecurityContext)this.prc.getInboundMessageContext().getSubcontext(WSSecurityContext.class, true);
        SAML20AssertionToken dummyToken = new SAML20AssertionToken(dummyAssertion);
        dummyToken.setSubjectConfirmation(dummyConfirmation);
        dummyToken.setValidationStatus(Token.ValidationStatus.INVALID);
        wssContext.getTokens().add(dummyToken);
        this.delegatedToken = new SAML20AssertionToken(this.delegatedAssertion);
        this.delegatedToken.setSubjectConfirmation(delegatedConfirmation);
        this.delegatedToken.setValidationStatus(Token.ValidationStatus.VALID);
        wssContext.getTokens().add(this.delegatedToken);
        this.action = new PopulateLibertyContext();
    }

    @Test
    public void testDefaultTokenStrategySuccess() throws ComponentInitializationException {
        this.action.initialize();
        PopulateLibertyContext.TokenStrategy strategy = new PopulateLibertyContext.TokenStrategy(this.action);
        Assert.assertSame((Object)strategy.apply(this.prc), (Object)this.delegatedToken);
    }

    @Test
    public void testDefaultTokenStrategyNullInput() throws ComponentInitializationException {
        this.action.initialize();
        PopulateLibertyContext.TokenStrategy strategy = new PopulateLibertyContext.TokenStrategy(this.action);
        Assert.assertNull((Object)strategy.apply(null));
    }

    @Test
    public void testDefaultTokenStrategyNoWSSContext() throws ComponentInitializationException {
        this.action.initialize();
        this.prc.getInboundMessageContext().removeSubcontext(WSSecurityContext.class);
        PopulateLibertyContext.TokenStrategy strategy = new PopulateLibertyContext.TokenStrategy(this.action);
        Assert.assertNull((Object)strategy.apply(this.prc));
    }

    @Test
    public void testDefaultTokenStrategyNoTokens() throws ComponentInitializationException {
        this.action.initialize();
        ((WSSecurityContext)this.prc.getInboundMessageContext().getSubcontext(WSSecurityContext.class)).getTokens().clear();
        PopulateLibertyContext.TokenStrategy strategy = new PopulateLibertyContext.TokenStrategy(this.action);
        Assert.assertNull((Object)strategy.apply(this.prc));
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        LibertySSOSContext libertyContext = (LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class);
        Assert.assertNotNull((Object)libertyContext);
        Assert.assertNotNull((Object)libertyContext.getAttestedToken());
        Assert.assertSame((Object)libertyContext.getAttestedToken(), (Object)this.delegatedAssertion);
        Assert.assertNotNull((Object)libertyContext.getAttestedSubjectConfirmationMethod());
        Assert.assertEquals((String)libertyContext.getAttestedSubjectConfirmationMethod(), (String)this.delegatedConfirmationMethod);
    }

    @Test
    public void testNoResolvedAssertionToken() throws ComponentInitializationException {
        this.action.setAssertionTokenStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)result, (String)"NoCredentials");
        LibertySSOSContext libertyContext = (LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class);
        Assert.assertNull((Object)libertyContext);
    }

    @Test
    public void testActivationCondition() throws ComponentInitializationException {
        this.action.setAssertionTokenStrategy(FunctionSupport.constant(null));
        this.action.setActivationCondition((Predicate)Predicates.alwaysFalse());
        this.action.initialize();
        Event result = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)result);
        LibertySSOSContext libertyContext = (LibertySSOSContext)this.prc.getSubcontext(LibertySSOSContext.class);
        Assert.assertNull((Object)libertyContext);
    }
}

