/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl.LibertyHTTPSOAP11Decoder;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class LibertyHTTPSOAP11DecoderTest
extends XMLObjectBaseTestCase {
    private LibertyHTTPSOAP11Decoder decoder;
    private MockHttpServletRequest httpRequest;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("POST");
        this.decoder = new LibertyHTTPSOAP11Decoder();
        this.decoder.setParserPool(parserPool);
        this.decoder.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            public HttpServletRequest get() {
                return LibertyHTTPSOAP11DecoderTest.this.httpRequest;
            }
        });
        this.decoder.initialize();
    }

    @Test
    public void testDecoding() throws Exception {
        String requestContent = "<soap11:Envelope xmlns:soap11=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap11:Body><samlp:Response ID=\"foo\" IssueInstant=\"1970-01-01T00:00:00.000Z\" Version=\"2.0\" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status></samlp:Response></soap11:Body></soap11:Envelope>";
        this.httpRequest.setContent(requestContent.getBytes());
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertNotNull((Object)((SOAP11Context)messageContext.getSubcontext(SOAP11Context.class)).getEnvelope());
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof Response));
    }

    protected String encodeMessage(XMLObject message) throws MarshallingException {
        marshallerFactory.getMarshaller(message).marshall(message);
        return SerializeSupport.nodeToString((Node)message.getDOM());
    }
}

