/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl;

import net.shibboleth.idp.saml.saml2.profile.delegation.messaging.impl.ProcessFrameworkHandler;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessFrameworkHandlerTest
extends SOAPMessagingBaseTestCase {
    private ProcessFrameworkHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new ProcessFrameworkHandler();
    }

    @Test
    public void testDefaultExpected() throws ComponentInitializationException, MessageHandlerException {
        Framework framework = (Framework)this.buildXMLObject(Framework.DEFAULT_ELEMENT_NAME);
        framework.setVersion("2.0");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)framework);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)framework));
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testDefaultUnexpected() throws ComponentInitializationException, MessageHandlerException {
        Framework framework = (Framework)this.buildXMLObject(Framework.DEFAULT_ELEMENT_NAME);
        framework.setVersion("3.0");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)framework);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
    }

    @Test
    public void testNonDefaultExpected() throws ComponentInitializationException, MessageHandlerException {
        Framework framework = (Framework)this.buildXMLObject(Framework.DEFAULT_ELEMENT_NAME);
        framework.setVersion("3.0");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)framework);
        this.handler.setExpectedVersion("3.0");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)framework));
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNonDefaultUnexpected() throws ComponentInitializationException, MessageHandlerException {
        Framework framework = (Framework)this.buildXMLObject(Framework.DEFAULT_ELEMENT_NAME);
        framework.setVersion("3.0");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)framework);
        this.handler.setExpectedVersion("2.5");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
    }
}

