/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.impl.PreProcessLogoutMessage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2aslo.Asynchronous;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PreProcessLogoutMessageTest
extends OpenSAMLInitBaseTestCase {
    private RequestContext src;
    private ProfileRequestContext prc;
    private PreProcessLogoutMessage action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new PreProcessLogoutMessage();
        this.action.initialize();
    }

    @Test
    public void testNoMessage() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testLogoutResponse() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"IsLogoutResponse");
    }

    @Test
    public void testLogoutRequest() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest(null));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testAssumeAsyncLogoutRequest() throws ComponentInitializationException {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest(null));
        this.action = new PreProcessLogoutMessage();
        this.action.setAssumeAsynchronousLogout(true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"IsLogoutRequestAsync");
    }

    @Test
    public void testAsyncLogoutRequest() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest(null));
        SAMLObjectBuilder extsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder asyncBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Asynchronous.DEFAULT_ELEMENT_NAME);
        ((LogoutRequest)this.prc.getInboundMessageContext().getMessage()).setExtensions((Extensions)extsBuilder.buildObject());
        ((LogoutRequest)this.prc.getInboundMessageContext().getMessage()).getExtensions().getUnknownXMLObjects().add(asyncBuilder.buildObject());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"IsLogoutRequestAsync");
    }
}

