/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.SAML2ActionTestingSupport;
import net.shibboleth.idp.saml.saml2.profile.config.SingleLogoutProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.impl.ProcessLogoutRequest;
import net.shibboleth.idp.saml.session.SAML1SPSession;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.saml.session.impl.SAML1SPSessionSerializer;
import net.shibboleth.idp.saml.session.impl.SAML2SPSessionSerializer;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.impl.testing.SessionManagerBaseTestCase;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProcessLogoutRequestTest
extends SessionManagerBaseTestCase {
    private SAMLObjectBuilder<SessionIndex> sessionIndexBuilder;
    private RequestContext src;
    private ProfileRequestContext prc;
    private ProcessLogoutRequest action;

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.sessionIndexBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(SessionIndex.DEFAULT_ELEMENT_NAME);
        SingleLogoutProfileConfiguration logoutConfig = new SingleLogoutProfileConfiguration();
        logoutConfig.setQualifiedNameIDFormats(Collections.singletonList("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
        this.src = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singletonList(logoutConfig)).buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.action = new ProcessLogoutRequest();
        this.action.setSessionResolver((SessionResolver)this.sessionManager);
        this.action.initialize();
    }

    protected void adjustProperties() throws ComponentInitializationException {
        this.sessionManager.setTrackSPSessions(true);
        this.sessionManager.setSecondaryServiceIndex(true);
        this.sessionManager.setSessionSlop(Duration.ofSeconds(54000L));
        SPSessionSerializerRegistry registry = new SPSessionSerializerRegistry();
        HashMap<Class, Object> mappings = new HashMap<Class, Object>();
        mappings.put(SAML1SPSession.class, new SAML1SPSessionSerializer(Duration.ofSeconds(54000L)));
        mappings.put(SAML2SPSession.class, new SAML2SPSessionSerializer(Duration.ofSeconds(54000L)));
        registry.setMappings(mappings);
        registry.initialize();
        this.sessionManager.setSPSessionSerializerRegistry(registry);
    }

    @Test
    public void testNoMessage() {
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testNoNameID() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest(null));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
    }

    @Test
    public void testNoSession() {
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"jdoe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"SessionNotFound");
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
    }

    @Test
    public void testSessionNoSPSessions() throws SessionException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"SessionNotFound");
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
    }

    @Test
    public void testBadQualifiers() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        nameId.setSPNameQualifier("affiliation");
        NameID nameIdForSession = SAML2ActionTestingSupport.buildNameID((String)"joe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameIdForSession, "index"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"SessionNotFound");
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testDefaultedRequestQualifiers() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        nameId.setNameQualifier("http://idp.example.org");
        nameId.setSPNameQualifier("http://sp.example.org");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        NameID nameIdForSession = SAML2ActionTestingSupport.buildNameID((String)"joe");
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameIdForSession, "index"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)session.getId(), (String)sessionCtx.getIdPSession().getId());
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)1);
        Assert.assertSame(logoutCtx.getIdPSessions().iterator().next(), (Object)sessionCtx.getIdPSession());
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)0);
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testDefaultedSessionQualifiers() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        NameID nameIdForSession = SAML2ActionTestingSupport.buildNameID((String)"joe");
        nameIdForSession.setNameQualifier("http://idp.example.org");
        nameIdForSession.setSPNameQualifier("http://sp.example.org");
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameIdForSession, "index"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)session.getId(), (String)sessionCtx.getIdPSession().getId());
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)1);
        Assert.assertSame(logoutCtx.getIdPSessions().iterator().next(), (Object)sessionCtx.getIdPSession());
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)0);
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testSessionOneSPSession() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)session.getId(), (String)sessionCtx.getIdPSession().getId());
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)1);
        Assert.assertSame(logoutCtx.getIdPSessions().iterator().next(), (Object)sessionCtx.getIdPSession());
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)0);
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testSessionTwoSPSessions() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        NameID nameId2 = SAML2ActionTestingSupport.buildNameID((String)"joe2");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index"));
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org/2", creation, expiration, nameId2, "index2"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)session.getId(), (String)sessionCtx.getIdPSession().getId());
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class, true);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)1);
        Assert.assertSame(logoutCtx.getIdPSessions().iterator().next(), (Object)sessionCtx.getIdPSession());
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)1);
        SAML2SPSession sp = (SAML2SPSession)logoutCtx.getSessions("http://sp.example.org/2").iterator().next();
        Assert.assertNotNull((Object)sp);
        Assert.assertEquals((Object)sp.getCreationInstant(), (Object)creation.truncatedTo(ChronoUnit.MILLIS));
        Assert.assertEquals((Object)sp.getExpirationInstant(), (Object)expiration.truncatedTo(ChronoUnit.MILLIS));
        Assert.assertTrue((boolean)SAML2ObjectSupport.areNameIDsEquivalent((NameID)nameId2, (NameID)sp.getNameID()));
        Assert.assertEquals((String)sp.getSessionIndex(), (String)"index2");
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testTwoSPSessionsWrongRequester() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        NameID nameId2 = SAML2ActionTestingSupport.buildNameID((String)"joe2");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId2));
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index"));
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org/2", creation, expiration, nameId2, "index2"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"SessionNotFound");
        Assert.assertNull((Object)this.prc.getSubcontext(SessionContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(SubjectContext.class));
        Assert.assertNull((Object)this.prc.getSubcontext(LogoutContext.class));
        this.sessionManager.destroySession(session.getId(), false);
    }

    @Test
    public void testTwoSessionsOneMatch() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        Cookie cookie2 = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        SessionIndex sessionIndex = (SessionIndex)this.sessionIndexBuilder.buildObject();
        sessionIndex.setValue("index");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        ((LogoutRequest)this.prc.getInboundMessageContext().getMessage()).getSessionIndexes().add(sessionIndex);
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index"));
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie2});
        IdPSession session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session2);
        session2.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index2"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNotNull((Object)sessionCtx);
        Assert.assertEquals((String)session.getId(), (String)sessionCtx.getIdPSession().getId());
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class, false);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)1);
        Assert.assertSame(logoutCtx.getIdPSessions().iterator().next(), (Object)sessionCtx.getIdPSession());
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)0);
        this.sessionManager.destroySession(session.getId(), false);
        this.sessionManager.destroySession(session2.getId(), false);
    }

    @Test
    public void testTwoSessions() throws SessionException, ResolverException {
        Cookie cookie = this.createSession("joe");
        Cookie cookie2 = this.createSession("joe");
        NameID nameId = SAML2ActionTestingSupport.buildNameID((String)"joe");
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildLogoutRequest((NameID)nameId));
        Instant creation = Instant.now();
        Instant expiration = creation.plusSeconds(3600L);
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        IdPSession session = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session);
        session.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index"));
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie2});
        IdPSession session2 = this.sessionManager.resolveSingle(new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()}));
        Assert.assertNotNull((Object)session2);
        session2.addSPSession((SPSession)new SAML2SPSession("http://sp.example.org", creation, expiration, nameId, "index2"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectContext subjectCtx = (SubjectContext)this.prc.getSubcontext(SubjectContext.class);
        Assert.assertNotNull((Object)subjectCtx);
        Assert.assertEquals((String)subjectCtx.getPrincipalName(), (String)"joe");
        SessionContext sessionCtx = (SessionContext)this.prc.getSubcontext(SessionContext.class);
        Assert.assertNull((Object)sessionCtx);
        LogoutContext logoutCtx = (LogoutContext)this.prc.getSubcontext(LogoutContext.class);
        Assert.assertNotNull((Object)logoutCtx);
        Assert.assertEquals((int)logoutCtx.getIdPSessions().size(), (int)2);
        Assert.assertEquals((int)logoutCtx.getSessionMap().size(), (int)0);
        this.sessionManager.destroySession(session.getId(), false);
        this.sessionManager.destroySession(session2.getId(), false);
    }
}

