/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.criterion.BestMatchLocationCriterion;

public class BestMatchLocationLookupStrategy
implements Function<ProfileRequestContext, BestMatchLocationCriterion> {
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropagationContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        this.logoutPropagationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public BestMatchLocationCriterion apply(@Nullable ProfileRequestContext input) {
        String acsLocation;
        LogoutPropagationContext propCtx = this.logoutPropagationContextLookupStrategy.apply(input);
        if (propCtx != null && propCtx.getSession() instanceof SAML2SPSession && (acsLocation = ((SAML2SPSession)propCtx.getSession()).getACSLocation()) != null) {
            return new BestMatchLocationCriterion(acsLocation);
        }
        return null;
    }
}

