/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.session.SAML1SPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1SPSessionCreationStrategy
implements Function<ProfileRequestContext, SPSession> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1SPSessionCreationStrategy.class);
    @Nonnull
    private final Duration sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;

    public SAML1SPSessionCreationStrategy(@Nonnull Duration lifetime) {
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SPSession apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext, no SPSession created");
            return null;
        }
        String issuer = rpCtx.getRelyingPartyId();
        if (issuer == null) {
            this.log.debug("No relying party ID, no SPSession created");
            return null;
        }
        Instant now = Instant.now();
        return new SAML1SPSession(issuer, now, now.plus(this.sessionLifetime));
    }
}

