/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.saml.saml2.profile.config.navigate.QualifiedNameIDFormatsLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;

public class ProcessLogoutRequest
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessLogoutRequest.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextCreationStrategy = new ChildContextLookup(SubjectContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextCreationStrategy = new ChildContextLookup(LogoutContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = new Function<ProfileRequestContext, CriteriaSet>(){

        @Override
        public CriteriaSet apply(ProfileRequestContext input) {
            Issuer issuer;
            LogoutRequest req = ProcessLogoutRequest.this.logoutRequest;
            NameID nameID = req == null ? null : req.getNameID();
            Issuer issuer2 = issuer = req == null ? null : req.getIssuer();
            if (req != null && issuer != null && nameID != null) {
                String nameIDString = nameID.getValue();
                String issuerString = issuer.getValue();
                assert (issuerString != null && nameIDString != null);
                return new CriteriaSet(new Criterion[]{new SPSessionCriterion(issuerString, nameIDString)});
            }
            return new CriteriaSet();
        }
    };
    @Nonnull
    private Function<ProfileRequestContext, LogoutRequest> logoutRequestLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> qualifiedNameIDFormatsLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> assertingPartyLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> relyingPartyLookupStrategy;
    @NonnullBeforeExec
    private LogoutRequest logoutRequest;
    @Nonnull
    private Set<String> qualifiedNameIDFormats;
    @Nullable
    private String assertingParty;
    @Nullable
    private String relyingParty;

    public ProcessLogoutRequest() {
        Function lrls = new MessageLookup(LogoutRequest.class).compose((Function)new InboundMessageContextLookup());
        assert (lrls != null);
        this.logoutRequestLookupStrategy = lrls;
        this.qualifiedNameIDFormatsLookupStrategy = new QualifiedNameIDFormatsLookupFunction();
        this.qualifiedNameIDFormats = CollectionSupport.emptySet();
        this.setAssertingPartyLookupStrategy((Function<ProfileRequestContext, String>)new IssuerLookupFunction());
        this.setRelyingPartyLookupStrategy((Function<ProfileRequestContext, String>)new RelyingPartyIdLookupFunction());
    }

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        this.checkSetterPreconditions();
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSubjectContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext creation strategy cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.checkSetterPreconditions();
        this.logoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext creation strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.checkSetterPreconditions();
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    public void setLogoutRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutRequest> strategy) {
        this.checkSetterPreconditions();
        this.logoutRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutRequest lookup strategy cannot be null");
    }

    public void setQualifiedNameIDFormatsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.checkSetterPreconditions();
        this.qualifiedNameIDFormatsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Qualified NameID Formats lookup strategy cannot be null");
    }

    public void setAssertingPartyLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.assertingPartyLookupStrategy = strategy;
    }

    public void setRelyingPartyLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionResolver == null) {
            throw new ComponentInitializationException("SessionResolver cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.logoutRequest = this.logoutRequestLookupStrategy.apply(profileRequestContext);
        if (this.logoutRequest == null) {
            this.log.warn("{} No LogoutRequest found to process", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        NameID nid = this.logoutRequest.getNameID();
        if (nid == null) {
            this.log.warn("{} LogoutRequest did not contain NameID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        if (nid.getValue() == null) {
            this.log.warn("{} LogoutRequest contained an empty (therefore invalid) NameID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        this.qualifiedNameIDFormats = new HashSet<String>(this.qualifiedNameIDFormatsLookupStrategy.apply(profileRequestContext));
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            SessionContext sessionCtx;
            Iterable sessions = this.sessionResolver.resolve((Object)this.sessionResolverCriteriaStrategy.apply(profileRequestContext));
            Iterator sessionIterator = sessions.iterator();
            LogoutContext logoutCtx = null;
            int count = 1;
            while (sessionIterator.hasNext()) {
                IdPSession session = (IdPSession)sessionIterator.next();
                assert (session != null);
                if (!this.sessionMatches(profileRequestContext, session)) {
                    this.log.debug("{} IdP session {} does not contain a matching SP session", (Object)this.getLogPrefix(), (Object)session.getId());
                    continue;
                }
                this.log.debug("{} LogoutRequest matches IdP session {}", (Object)this.getLogPrefix(), (Object)session.getId());
                if (logoutCtx == null) {
                    logoutCtx = this.logoutContextCreationStrategy.apply(profileRequestContext);
                    if (logoutCtx == null) {
                        this.log.error("{} Unable to create or locate LogoutContext", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                        return;
                    }
                    SubjectContext subjectCtx = this.subjectContextCreationStrategy.apply(profileRequestContext);
                    if (subjectCtx != null) {
                        subjectCtx.setPrincipalName(session.getPrincipalName());
                    }
                }
                logoutCtx.getIdPSessions().add(session);
                for (SPSession spSession : session.getSPSessions()) {
                    assert (spSession != null);
                    if (this.sessionMatches(profileRequestContext, spSession)) continue;
                    logoutCtx.getSessionMap().put((Object)spSession.getId(), (Object)spSession);
                    logoutCtx.getKeyedSessionMap().put(Integer.toString(count++), spSession);
                }
            }
            if (logoutCtx == null) {
                this.log.info("{} No active session(s) found matching LogoutRequest", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
            } else if (logoutCtx.getIdPSessions().size() == 1 && (sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext)) != null) {
                sessionCtx.setIdPSession((IdPSession)logoutCtx.getIdPSessions().iterator().next());
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving matching session(s)", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
        }
    }

    private boolean sessionMatches(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPSession session) {
        for (SPSession spSession : session.getSPSessions()) {
            assert (spSession != null);
            if (!this.sessionMatches(profileRequestContext, spSession)) continue;
            return true;
        }
        return false;
    }

    private boolean sessionMatches(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SPSession session) {
        assert (this.isPreExecuteCalled());
        if (session instanceof SAML2SPSession) {
            SAML2SPSession saml2Session = (SAML2SPSession)session;
            Issuer issuer = this.logoutRequest.getIssuer();
            if (issuer == null || !saml2Session.getId().equals(issuer.getValue())) {
                return false;
            }
            String format = saml2Session.getNameID().getFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            NameID requestedNameID = this.logoutRequest.getNameID();
            assert (requestedNameID != null);
            if ("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(format) || "urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(format) || this.qualifiedNameIDFormats.contains(format)) {
                if (this.assertingParty == null && this.assertingPartyLookupStrategy != null) {
                    this.assertingParty = this.assertingPartyLookupStrategy.apply(profileRequestContext);
                }
                if (this.relyingParty == null && this.relyingPartyLookupStrategy != null) {
                    this.relyingParty = this.relyingPartyLookupStrategy.apply(profileRequestContext);
                }
                if (!SAML2ObjectSupport.areNameIDsEquivalent((NameID)requestedNameID, (NameID)saml2Session.getNameID(), (String)this.assertingParty, (String)this.relyingParty)) {
                    return false;
                }
            } else if (!SAML2ObjectSupport.areNameIDsEquivalent((NameID)requestedNameID, (NameID)saml2Session.getNameID())) {
                return false;
            }
            if (this.logoutRequest.getSessionIndexes().isEmpty()) {
                return true;
            }
            for (SessionIndex index : this.logoutRequest.getSessionIndexes()) {
                String value = index.getValue();
                if (value == null || !value.equals(saml2Session.getSessionIndex())) continue;
                return true;
            }
        }
        return false;
    }
}

