/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.saml.common.SAMLException;

public class CryptoTransientIdGenerationStrategy
extends AbstractIdentifiableInitializableComponent
implements TransientIdGenerationStrategy {
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nonnull
    private Duration idLifetime;

    public CryptoTransientIdGenerationStrategy() {
        Duration fourHours = Duration.ofHours(4L);
        assert (fourHours != null);
        this.idLifetime = fourHours;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    @Nonnull
    public Duration getIdLifetime() {
        return this.idLifetime;
    }

    public void setIdLifetime(@Nonnull Duration lifetime) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Lifetime must be positive");
        this.idLifetime = lifetime;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSealer) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName) throws SAMLException {
        this.checkComponentActive();
        StringBuilder principalTokenIdBuilder = new StringBuilder();
        principalTokenIdBuilder.append(relyingPartyId).append("!").append(principalName);
        try {
            String result = principalTokenIdBuilder.toString();
            assert (result != null);
            return this.dataSealer.wrap(result, Instant.now().plus(this.idLifetime));
        }
        catch (DataSealerException e) {
            throw new SAMLException("Exception wrapping principal identifier", (Exception)((Object)e));
        }
    }
}

