/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Scoping;

public abstract class AbstractScopingAuditExtractor<T>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy;

    protected AbstractScopingAuditExtractor(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        AuthnRequest request = this.requestLookupStrategy.apply(input);
        if (request != null) {
            return this.doApply(request.getScoping());
        }
        return null;
    }

    @Nullable
    protected abstract T doApply(@Nullable Scoping var1);
}

