/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;

public class AssertionInstantAuditExtractor
implements Function<ProfileRequestContext, Collection<Instant>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public AssertionInstantAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<Instant> apply(@Nullable ProfileRequestContext input) {
        SAMLObject message = this.responseLookupStrategy.apply(input);
        if (message != null) {
            Assertion a;
            Instant ts;
            if (message instanceof ArtifactResponse) {
                ArtifactResponse m = (ArtifactResponse)message;
                message = m.getMessage();
            }
            if (message instanceof org.opensaml.saml.saml2.core.Response) {
                org.opensaml.saml.saml2.core.Response resp = (org.opensaml.saml.saml2.core.Response)message;
                List assertions = resp.getAssertions();
                if (!assertions.isEmpty()) {
                    return assertions.stream().map(org.opensaml.saml.saml2.core.Assertion::getIssueInstant).collect(Collectors.toList());
                }
            } else if (message instanceof Response) {
                Response resp = (Response)message;
                List assertions = resp.getAssertions();
                if (!assertions.isEmpty()) {
                    return assertions.stream().map(Assertion::getIssueInstant).collect(Collectors.toList());
                }
            } else if (message instanceof org.opensaml.saml.saml2.core.Assertion) {
                org.opensaml.saml.saml2.core.Assertion a2 = (org.opensaml.saml.saml2.core.Assertion)message;
                Instant ts2 = a2.getIssueInstant();
                if (ts2 != null) {
                    return CollectionSupport.singletonList((Object)ts2);
                }
            } else if (message instanceof Assertion && (ts = (a = (Assertion)message).getIssueInstant()) != null) {
                return CollectionSupport.singletonList((Object)ts);
            }
        }
        return CollectionSupport.emptyList();
    }
}

