/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class StatusCodeAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public StatusCodeAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof Response) {
                org.opensaml.saml.saml1.core.StatusCode sc;
                Response r = (Response)response;
                Status status = r.getStatus();
                org.opensaml.saml.saml1.core.StatusCode statusCode = sc = status != null ? status.getStatusCode() : null;
                if (sc != null && sc.getValue() != null) {
                    QName q = sc.getValue();
                    assert (q != null);
                    return q.getLocalPart();
                }
            } else if (response instanceof StatusResponseType) {
                StatusCode sc;
                StatusResponseType srt = (StatusResponseType)response;
                org.opensaml.saml.saml2.core.Status status = srt.getStatus();
                StatusCode statusCode = sc = status != null ? status.getStatusCode() : null;
                if (sc != null) {
                    return sc.getValue();
                }
            }
        }
        return null;
    }
}

