/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class SubStatusCodeAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public SubStatusCodeAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof Response) {
                org.opensaml.saml.saml1.core.StatusCode sc;
                Response r = (Response)response;
                Status status = r.getStatus();
                org.opensaml.saml.saml1.core.StatusCode statusCode = sc = status != null ? status.getStatusCode() : null;
                if (sc != null && sc.getStatusCode() != null) {
                    ArrayList<String> values = new ArrayList<String>(1);
                    do {
                        if ((sc = sc.getStatusCode()) == null || sc.getValue() == null) continue;
                        QName q = sc.getValue();
                        assert (q != null);
                        values.add(q.getLocalPart());
                    } while (sc != null && sc.getStatusCode() != null);
                    return values;
                }
            } else if (response instanceof StatusResponseType) {
                StatusCode sc;
                StatusResponseType srt = (StatusResponseType)response;
                org.opensaml.saml.saml2.core.Status status = srt.getStatus();
                StatusCode statusCode = sc = status != null ? status.getStatusCode() : null;
                if (sc != null && sc.getStatusCode() != null) {
                    ArrayList<String> values = new ArrayList<String>(1);
                    do {
                        if ((sc = sc.getStatusCode()) == null || sc.getValue() == null) continue;
                        values.add(sc.getValue());
                    } while (sc != null && sc.getStatusCode() != null);
                    return values;
                }
            }
        }
        return CollectionSupport.emptyList();
    }
}

