/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.audit.impl.AuthnContextAuditExtractor;
import net.shibboleth.idp.saml.audit.impl.StatusCodeAuditExtractor;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.StatusCode;

public class WriteFTICKSLog
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String FTICKS_LOG_CATEGORY = "Shibboleth-FTICKS";
    @NonnullAfterInit
    @NotEmpty
    private String federationId;
    @NonnullAfterInit
    @NotEmpty
    private String digestAlgorithm;
    @Nullable
    private String salt;
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> responderLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> usernameLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> authenticationMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> statusCodeLookupStrategy;
    @NonnullAfterInit
    private StringDigester digester;

    public WriteFTICKSLog() {
        Function unls = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
        assert (unls != null);
        this.usernameLookupStrategy = unls;
        Function para = new MessageLookup(SAMLObject.class).compose((Function)new OutboundMessageContextLookup());
        assert (para != null);
        this.authenticationMethodLookupStrategy = new AuthnContextAuditExtractor(para);
        para = new MessageLookup(SAMLObject.class).compose((Function)new OutboundMessageContextLookup());
        assert (para != null);
        this.statusCodeLookupStrategy = new StatusCodeAuditExtractor(para);
    }

    public void setFederationId(@Nonnull @NotEmpty String id) {
        this.federationId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Federation ID cannot be null or empty");
    }

    public void setDigestAlgorithm(@Nonnull @NotEmpty String alg) {
        this.digestAlgorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alg), (String)"Digest algorithm cannot be null or empty");
    }

    public void setSalt(@Nullable String s) {
        this.salt = s != null && !s.isEmpty() ? s : null;
    }

    public void setRelyingPartyLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying Party ID lookup strategy cannot be null");
    }

    public void setResponderLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.responderLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Responder ID lookup strategy cannot be null");
    }

    public void setUsernameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.usernameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Username lookup strategy cannot be null");
    }

    public void setAuthenticationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.authenticationMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication method lookup strategy cannot be null");
    }

    public void setStatusCodeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.statusCodeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"StatusCode lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.federationId == null) {
            throw new ComponentInitializationException("Federation ID cannot be null or empty.");
        }
        if (this.digestAlgorithm == null) {
            throw new ComponentInitializationException("Digest Algorithm cannot be null or empty.");
        }
        try {
            assert (this.digestAlgorithm != null);
            this.digester = new StringDigester(this.digestAlgorithm, StringDigester.OutputFormat.HEX_LOWER);
            this.digester.setSalt(this.salt);
            this.digester.setRequireSalt(true);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentInitializationException((Exception)e);
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        StringBuilder record = new StringBuilder("F-TICKS/");
        record.append(this.federationId).append("/1.0#TS=").append(System.currentTimeMillis() / 1000L);
        String field = this.relyingPartyLookupStrategy.apply(profileRequestContext);
        if (field != null && !field.isEmpty()) {
            record.append("#RP=").append(field);
        }
        if ((field = this.responderLookupStrategy.apply(profileRequestContext)) != null && !field.isEmpty()) {
            record.append("#AP=").append(field);
        }
        if ((field = this.usernameLookupStrategy.apply(profileRequestContext)) != null && !field.isEmpty() && (field = this.digester.apply(field)) != null && !field.isEmpty()) {
            record.append("#PN=").append(field);
        }
        if ((field = this.authenticationMethodLookupStrategy.apply(profileRequestContext)) != null && !field.isEmpty()) {
            record.append("#AM=").append(field);
        }
        if ((field = this.statusCodeLookupStrategy.apply(profileRequestContext)) != null && (StatusCode.SUCCESS.getLocalPart().equals(field) || "urn:oasis:names:tc:SAML:2.0:status:Success".equals(field))) {
            record.append("#RESULT=OK");
        } else {
            record.append("#RESULT=FAIL");
        }
        record.append("#");
        LoggerFactory.getLogger((String)FTICKS_LOG_CATEGORY).info(record.toString());
    }
}

