/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.impl.AbstractSAMLProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate;

public class ArtifactResolutionProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements net.shibboleth.saml.saml1.profile.config.ArtifactResolutionProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.saml1.query.artifact";
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate;

    public ArtifactResolutionProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/saml1/query/artifact");
    }

    protected ArtifactResolutionProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new NoIntegrityMessageChannelPredicate());
        this.signAssertionsPredicate = PredicateSupport.alwaysFalse();
    }

    public boolean isSignAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signAssertionsPredicate.test(profileRequestContext);
    }

    public void setSignAssertions(boolean flag) {
        this.signAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }
}

