/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.criterion.BestMatchLocationCriterion;

public class BestMatchLocationLookupStrategy
implements Function<ProfileRequestContext, BestMatchLocationCriterion> {
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropagationContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        this.logoutPropagationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public BestMatchLocationCriterion apply(@Nullable ProfileRequestContext input) {
        String acsLocation;
        SPSession session;
        LogoutPropagationContext propCtx = this.logoutPropagationContextLookupStrategy.apply(input);
        SPSession sPSession = session = propCtx != null ? propCtx.getSession() : null;
        if (session != null && session instanceof SAML2SPSession && (acsLocation = ((SAML2SPSession)session).getACSLocation()) != null) {
            return new BestMatchLocationCriterion(acsLocation);
        }
        return null;
    }
}

