/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.impl.TransientIdParameters;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public abstract class BaseTransientDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseTransientDecoder.class);
    @NonnullAfterInit
    private StorageService idStore;
    @Nullable
    private String logPrefix;

    @NonnullAfterInit
    public StorageService getIdStore() {
        return this.idStore;
    }

    public void setIdStore(@Nonnull StorageService store) {
        this.checkSetterPreconditions();
        this.idStore = (StorageService)Constraint.isNotNull((Object)store, (String)"StorageService cannot be null");
    }

    @Nullable
    public String decode(@Nonnull String transientId, @Nonnull @NotEmpty String requesterId) throws NameDecoderException {
        this.checkComponentActive();
        try {
            StorageRecord record = this.idStore.read("TransientId", transientId);
            if (null == record) {
                this.log.info("{} Could not find transient identifier", (Object)this.getLogPrefix());
                return null;
            }
            TransientIdParameters param = new TransientIdParameters(record.getValue());
            if (!requesterId.equals(param.getAttributeRecipient())) {
                this.log.warn("{} Transient identifier issued to {} but requested by {}", new Object[]{this.getLogPrefix(), param.getAttributeRecipient(), requesterId});
                throw new NameDecoderException("Misuse of identifier by an improper relying party");
            }
            return param.getPrincipal();
        }
        catch (IOException e) {
            this.log.error("{} I/O error looking up transient identifier", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idStore) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No Id store set");
        }
        this.log.debug("{} using the store '{}'", (Object)this.getLogPrefix(), (Object)this.idStore.getId());
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Transient Decoder '").append(this.getId()).append("':");
            prefix = builder.toString();
            assert (prefix != null);
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

