/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.nameid.impl.TransientIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.TransientIdParameters;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.RandomIdentifierParameterSpec;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class StoredTransientIdGenerationStrategy
extends AbstractIdentifiableInitializableComponent
implements TransientIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredTransientIdGenerationStrategy.class);
    @NonnullAfterInit
    private StorageService idStore;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idGenerator;
    private int idSize = 16;
    @Nonnull
    private Duration idLifetime;

    public StoredTransientIdGenerationStrategy() {
        Duration fourHours = Duration.ofHours(4L);
        assert (fourHours != null);
        this.idLifetime = fourHours;
    }

    public void setIdStore(@Nonnull StorageService store) {
        this.checkSetterPreconditions();
        this.idStore = (StorageService)Constraint.isNotNull((Object)store, (String)"StorageService cannot be null");
    }

    public void setIdGenerator(@Nonnull IdentifierGenerationStrategy generator) {
        this.checkSetterPreconditions();
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Positive
    public int getIdSize() {
        return this.idSize;
    }

    public void setIdSize(@Positive int size) {
        this.checkSetterPreconditions();
        this.idSize = Constraint.isGreaterThan((int)0, (int)size, (String)"ID size must be positive");
    }

    @Nonnull
    public Duration getIdLifetime() {
        return this.idLifetime;
    }

    public void setIdLifetime(@Nonnull Duration lifetime) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)lifetime, (String)"ID lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"ID lifetime must be greater than 0");
        this.idLifetime = lifetime;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idStore) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.idGenerator == null) {
            try {
                this.idGenerator = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.RANDOM, (IdentifierGenerationStrategy.ParameterSpec)new RandomIdentifierParameterSpec(null, Integer.valueOf(this.idSize), null));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw new ComponentInitializationException((Exception)e);
            }
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName) throws SAMLException {
        this.checkComponentActive();
        try {
            String principalTokenId = new TransientIdParameters(relyingPartyId, principalName).encode();
            String id = this.idGenerator.generateIdentifier();
            this.log.debug("Creating new transient ID '{}'", (Object)id);
            Instant expiration = Instant.now().plus(this.idLifetime);
            for (int collisions = 0; collisions < 5; ++collisions) {
                if (!this.idStore.create("TransientId", id, principalTokenId, Long.valueOf(expiration.toEpochMilli()))) continue;
                return id;
            }
            throw new SAMLException("Exceeded allowable number of collisions");
        }
        catch (IOException e) {
            throw new SAMLException((Exception)e);
        }
    }
}

