/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.slf4j.Logger;

public class InitializeOutboundMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> selfIdentityLookupStrategy = new IssuerLookupFunction();
    @NonnullBeforeExec
    private SAMLPeerEntityContext peerEntityCtx;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setSelfIdentityLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.selfIdentityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Self identity lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (relyingPartyCtx == null) {
            this.log.debug("{} No relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        BaseContext identifyingCtx = relyingPartyCtx.getRelyingPartyIdContextTree();
        if (identifyingCtx == null || !(identifyingCtx instanceof SAMLPeerEntityContext)) {
            this.log.debug("{} No SAML peer entity context found via relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.peerEntityCtx = (SAMLPeerEntityContext)identifyingCtx;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setOutboundMessageContext(msgCtx);
        SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)msgCtx.ensureSubcontext(SAMLSelfEntityContext.class);
        selfContext.setEntityId(this.selfIdentityLookupStrategy.apply(profileRequestContext));
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)msgCtx.ensureSubcontext(SAMLPeerEntityContext.class);
        peerContext.setEntityId(this.peerEntityCtx.getEntityId());
        SAMLMetadataContext inboundMetadataCtx = (SAMLMetadataContext)this.peerEntityCtx.getSubcontext(SAMLMetadataContext.class);
        if (inboundMetadataCtx != null) {
            SAMLMetadataContext outboundMetadataCtx = (SAMLMetadataContext)peerContext.ensureSubcontext(SAMLMetadataContext.class);
            outboundMetadataCtx.setEntityDescriptor(inboundMetadataCtx.getEntityDescriptor());
            outboundMetadataCtx.setRoleDescriptor(inboundMetadataCtx.getRoleDescriptor());
            AttributeConsumingServiceContext acsCtx = (AttributeConsumingServiceContext)inboundMetadataCtx.getSubcontext(AttributeConsumingServiceContext.class);
            if (null != acsCtx) {
                ((AttributeConsumingServiceContext)outboundMetadataCtx.ensureSubcontext(AttributeConsumingServiceContext.class)).setAttributeConsumingService(acsCtx.getAttributeConsumingService());
            }
        }
        this.log.debug("{} Initialized outbound message context", (Object)this.getLogPrefix());
    }
}

