/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2ProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ArtifactAwareProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements SAMLArtifactAwareProfileConfiguration,
SAMLArtifactConsumerProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, SAMLArtifactConfiguration> artifactConfigurationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<MessageContext> signArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate();
    @Nonnull
    private Predicate<MessageContext> clientTLSArtifactRequestsPredicate;

    protected AbstractSAML2ArtifactAwareProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        Predicate pred = new NoIntegrityMessageChannelPredicate().negate();
        assert (pred != null);
        this.clientTLSArtifactRequestsPredicate = pred;
    }

    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.artifactConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfigurationLookupStrategy = FunctionSupport.constant((Object)config);
    }

    public void setArtifactConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLArtifactConfiguration> strategy) {
        this.artifactConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isSignArtifactRequests(@Nullable MessageContext messageContext) {
        return this.signArtifactRequestsPredicate.test(messageContext);
    }

    public void setSignArtifactRequests(boolean flag) {
        this.signArtifactRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact request signing may not be null");
    }

    public boolean isClientTLSArtifactRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSArtifactRequestsPredicate.test(messageContext);
    }

    public void setClientTLSArtifactRequests(boolean flag) {
        this.clientTLSArtifactRequestsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setClientTLSArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact client TLS use may not be null");
    }
}

