/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class LogoutPropagationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    public boolean apply(ProfileRequestContext input) {
        return this.activationCondition.apply((Object)input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof LogoutPropagationFlowDescriptor) {
            return this.getId().equals(((LogoutPropagationFlowDescriptor)((Object)obj)).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("flowId", (Object)this.getId()).toString();
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Nonnull
        private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);
        @Nonnull
        private Class<? extends SPSession> sessionType = BasicSPSession.class;

        public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
            this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext lookup strategy cannot be null");
        }

        public void setSessionType(@Nonnull Class<? extends SPSession> type) {
            this.sessionType = (Class)Constraint.isNotNull(type, (String)"SPSession type cannot be null");
        }

        public boolean apply(ProfileRequestContext input) {
            LogoutContext logoutCtx = (LogoutContext)((Object)this.logoutContextLookupStrategy.apply((Object)input));
            if (logoutCtx != null || logoutCtx.getSessionMap().size() == 1) {
                return this.sessionType.isInstance(logoutCtx.getSessionMap().values().iterator().next());
            }
            return false;
        }
    }
}

