/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.criterion;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.Criterion;

public final class SessionIdCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private final String id;

    public SessionIdCriterion(@Nonnull @NotEmpty String sessionId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sessionId), (String)"Session ID cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getSessionId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionId", (Object)this.id).toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SessionIdCriterion) {
            return this.id.equals(((SessionIdCriterion)obj).id);
        }
        return false;
    }
}

