/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class SPSessionSerializerRegistry
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SPSessionSerializerRegistry.class);
    @Nonnull
    @NonnullElements
    private Map<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> registry = new HashMap<Class<? extends SPSession>, StorageSerializer<? extends SPSession>>();

    public SPSessionSerializerRegistry() {
        this(null);
    }

    @Autowired
    public SPSessionSerializerRegistry(@Nullable @NonnullElements Collection<Entry<?>> serializers) {
        if (serializers != null) {
            serializers.forEach(e -> this.registry.put(e.getType(), e.getSerializer()));
        }
    }

    public void setMappings(@Nonnull @NonnullElements Map<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Map cannot be null");
        for (Map.Entry<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.registry.put(entry.getKey(), entry.getValue());
        }
    }

    @Nullable
    public <T extends SPSession> StorageSerializer<T> lookup(@Nonnull Class<T> type) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull(type, (String)"SPSession type cannot be null");
        StorageSerializer<? extends SPSession> serializer = this.registry.get(type);
        if (serializer != null) {
            this.log.debug("Registry located StorageSerializer of type '{}' for SPSession type '{}'", (Object)serializer.getClass().getName(), type);
            return serializer;
        }
        this.log.debug("Registry failed to locate StorageSerializer for SPSession type '{}'", type);
        return null;
    }

    public static class Entry<T extends SPSession> {
        @Nonnull
        private final Class<T> sessionType;
        @Nonnull
        private final StorageSerializer<T> serializer;

        public Entry(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nullable @ParameterName(name="object") StorageSerializer<T> object) {
            this.sessionType = (Class)Constraint.isNotNull(claz, (String)"Session type cannot be null");
            this.serializer = object;
        }

        @Nonnull
        Class<T> getType() {
            return this.sessionType;
        }

        @Nullable
        StorageSerializer<T> getSerializer() {
            return this.serializer;
        }
    }
}

