/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import java.security.Principal;
import java.time.Instant;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.session.AbstractIdPSession;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdPSessionTest {
    @Test
    public void testInstantiation() throws Exception {
        Instant start = Instant.now();
        Thread.sleep(50L);
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        Assert.assertNotNull((Object)session.getAuthenticationResults());
        Assert.assertFalse((boolean)session.getAuthenticationResults().iterator().hasNext());
        Assert.assertTrue((boolean)session.getCreationInstant().isAfter(start));
        Assert.assertEquals((String)session.getId(), (String)"test");
        Assert.assertEquals((String)session.getPrincipalName(), (String)"foo");
        Assert.assertEquals((Object)session.getLastActivityInstant(), (Object)session.getCreationInstant());
        Assert.assertNotNull((Object)session.getSPSessions());
        Assert.assertFalse((boolean)session.getSPSessions().iterator().hasNext());
        try {
            new DummyIdPSession(null, null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new DummyIdPSession("", "");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new DummyIdPSession("  ", "  ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new DummyIdPSession("test", null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testLastActivityInstant() throws Exception {
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        Instant now = Instant.now();
        Thread.sleep(50L);
        session.setLastActivityInstant(Instant.now());
        Assert.assertTrue((boolean)session.getLastActivityInstant().isAfter(now));
        session.setLastActivityInstant(now);
        Assert.assertEquals((Object)session.getLastActivityInstant(), (Object)now);
    }

    @Test
    public void testAddressValidation() throws Exception {
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        Assert.assertTrue((boolean)session.checkAddress("127.0.0.1"));
        Assert.assertTrue((boolean)session.checkAddress("127.0.0.1"));
        Assert.assertFalse((boolean)session.checkAddress("127.0.0.2"));
        Assert.assertTrue((boolean)session.checkAddress("::1"));
        Assert.assertTrue((boolean)session.checkAddress("::1"));
        Assert.assertFalse((boolean)session.checkAddress("fe80::5a55:caff:fef2:65a3"));
        Assert.assertTrue((boolean)session.checkAddress("zorkmid"));
        Assert.assertFalse((boolean)session.checkAddress("bugbear"));
    }

    @Test
    public void testAddSPSessions() throws SessionException {
        Instant now = Instant.now();
        Instant exp = now.plusSeconds(60L);
        BasicSPSession svcSession1 = new BasicSPSession("svc1", now, exp);
        BasicSPSession svcSession2 = new BasicSPSession("svc2", now, exp);
        BasicSPSession svcSession3 = new BasicSPSession("svc3", now, exp);
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        session.addSPSession((SPSession)svcSession1);
        Assert.assertEquals((int)session.getSPSessions().size(), (int)1);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertEquals((Object)session.getSPSession("svc1"), (Object)svcSession1);
        session.addSPSession((SPSession)svcSession2);
        Assert.assertEquals((int)session.getSPSessions().size(), (int)2);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertEquals((Object)session.getSPSession("svc1"), (Object)svcSession1);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
        Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
        session.addSPSession((SPSession)svcSession3);
        Assert.assertEquals((int)session.getSPSessions().size(), (int)3);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertEquals((Object)session.getSPSession("svc1"), (Object)svcSession1);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
        Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession3));
        Assert.assertEquals((Object)session.getSPSession("svc3"), (Object)svcSession3);
        try {
            session.addSPSession(null);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((int)session.getSPSessions().size(), (int)3);
            Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession1));
            Assert.assertEquals((Object)session.getSPSession("svc1"), (Object)svcSession1);
            Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
            Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
            Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession3));
            Assert.assertEquals((Object)session.getSPSession("svc3"), (Object)svcSession3);
        }
        session.addSPSession((SPSession)svcSession1);
        Assert.assertEquals((int)session.getSPSessions().size(), (int)3);
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertEquals((Object)session.getSPSession("svc1"), (Object)svcSession1);
    }

    @Test
    public void testRemoveSPSession() throws SessionException {
        Instant now = Instant.now();
        Instant exp = now.plusSeconds(60L);
        BasicSPSession svcSession1 = new BasicSPSession("svc1", now, exp);
        BasicSPSession svcSession2 = new BasicSPSession("svc2", now, exp);
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        session.addSPSession((SPSession)svcSession1);
        session.addSPSession((SPSession)svcSession2);
        Assert.assertTrue((boolean)session.removeSPSession((SPSession)svcSession1));
        Assert.assertEquals((int)session.getSPSessions().size(), (int)1);
        Assert.assertFalse((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
        Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
        Assert.assertFalse((boolean)session.removeSPSession((SPSession)svcSession1));
        Assert.assertEquals((int)session.getSPSessions().size(), (int)1);
        Assert.assertFalse((boolean)session.getSPSessions().contains(svcSession1));
        Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
        Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
        try {
            session.removeSPSession(null);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((int)session.getSPSessions().size(), (int)1);
            Assert.assertFalse((boolean)session.getSPSessions().contains(svcSession1));
            Assert.assertTrue((boolean)session.getSPSessions().contains(svcSession2));
            Assert.assertEquals((Object)session.getSPSession("svc2"), (Object)svcSession2);
        }
    }

    @Test
    public void testRemoveAuthenticationResult() throws SessionException {
        AuthenticationResult event1 = new AuthenticationResult("foo", (Principal)new UsernamePrincipal("john"));
        AuthenticationResult event2 = new AuthenticationResult("bar", (Principal)new UsernamePrincipal("john"));
        AuthenticationResult event3 = new AuthenticationResult("baz", (Principal)new UsernamePrincipal("john"));
        DummyIdPSession session = new DummyIdPSession("test", "foo");
        session.addAuthenticationResult(event1);
        session.addAuthenticationResult(event2);
        session.addAuthenticationResult(event3);
        session.removeAuthenticationResult(event2);
        Assert.assertEquals((int)session.getAuthenticationResults().size(), (int)2);
        Assert.assertTrue((boolean)session.getAuthenticationResults().contains(event1));
        Assert.assertEquals((Object)session.getAuthenticationResult("foo"), (Object)event1);
        Assert.assertTrue((boolean)session.getAuthenticationResults().contains(event3));
        Assert.assertEquals((Object)session.getAuthenticationResult("baz"), (Object)event3);
        session.removeAuthenticationResult(event3);
        Assert.assertEquals((int)session.getAuthenticationResults().size(), (int)1);
        Assert.assertTrue((boolean)session.getAuthenticationResults().contains(event1));
        Assert.assertEquals((Object)session.getAuthenticationResult("foo"), (Object)event1);
        try {
            session.removeAuthenticationResult(null);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((int)session.getAuthenticationResults().size(), (int)1);
            Assert.assertTrue((boolean)session.getAuthenticationResults().contains(event1));
            Assert.assertEquals((Object)session.getAuthenticationResult("foo"), (Object)event1);
        }
    }

    private class DummyIdPSession
    extends AbstractIdPSession {
        public DummyIdPSession(String sessionId, String canonicalName) {
            super(sessionId, canonicalName, Instant.now());
        }

        public void updateAuthenticationResultActivity(AuthenticationResult result) throws SessionException {
        }
    }
}

