/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.context.navigate;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class CanonicalUsernameLookupStrategy
implements Function<ProfileRequestContext, String> {
    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input != null) {
            IdPSession idpSession;
            SubjectCanonicalizationContext c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class);
            if (c14nContext != null && c14nContext.getPrincipalName() != null) {
                return c14nContext.getPrincipalName();
            }
            SessionContext sessionContext = (SessionContext)input.getSubcontext(SessionContext.class);
            if (sessionContext != null && (idpSession = sessionContext.getIdPSession()) != null) {
                return idpSession.getPrincipalName();
            }
        }
        return null;
    }
}

