/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 2131709003267781456L;
    private static Logger log = LoggerFactory.getLogger(ServiceNameTag.class);
    private static final String DEFAULT_VALUE = "Unspecified Service Provider";
    private String defaultValue;

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public int doStartTag() throws JspException {
        try {
            String rawServiceName = this.getServiceName();
            String serviceName = HTMLEncoder.encodeForHTML((String)rawServiceName);
            if (null == serviceName) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                boolean written = false;
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                    written = true;
                }
                if (!written) {
                    this.pageContext.getOut().print(this.defaultValue != null ? this.defaultValue : DEFAULT_VALUE);
                }
            } else {
                this.pageContext.getOut().print(serviceName);
            }
        }
        catch (IOException e) {
            log.warn("Error generating name");
            throw new JspException("StartTag", (Throwable)e);
        }
        return super.doStartTag();
    }
}

