/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRPUIInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetRPUIInformation.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyUIContext> rpUIContextCreateStrategy = Functions.compose((Function)new ChildContextLookup(RelyingPartyUIContext.class, true), (Function)new ChildContextLookup(AuthenticationContext.class, true));
    @Nullable
    private List<String> fallbackLanguages;
    @Nullable
    private EntityDescriptor entityDescriptor;
    @Nullable
    private SPSSODescriptor spSSODescriptor;
    private RelyingPartyUIContext rpUIContext;
    private AttributeConsumingService acsDesriptor;

    @Nonnull
    public Function<ProfileRequestContext, SAMLMetadataContext> getMetadataContextLookupStrategy() {
        return this.metadataContextLookupStrategy;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strgy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    public Function<ProfileRequestContext, RelyingPartyUIContext> getRPUIContextCreateStrategy() {
        return this.rpUIContextCreateStrategy;
    }

    public void setRPUIContextCreateStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyUIContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpUIContextCreateStrategy = (Function)Constraint.isNotNull(strategy, (String)"Injected RPUI Strategy cannot be null");
    }

    public void setFallbackLanguages(@Nonnull @NonnullElements List<String> langs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.fallbackLanguages = langs != null ? new ArrayList<String>(Collections2.filter(langs, (Predicate)Predicates.notNull())) : null;
    }

    @Nullable
    protected UIInfo getRPUInfo() {
        Extensions exts = this.spSSODescriptor.getExtensions();
        if (exts != null) {
            for (XMLObject object : exts.getOrderedChildren()) {
                if (!(object instanceof UIInfo)) continue;
                return (UIInfo)object;
            }
        }
        return null;
    }

    @Nonnull
    @NonnullElements
    protected List<String> getBrowserLanguages() {
        Enumeration locales = this.getHttpServletRequest().getLocales();
        LazyList languages = new LazyList();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (null == locale.getLanguage()) continue;
            languages.add(locale.getLanguage());
        }
        return languages;
    }

    protected boolean doPreExecute(ProfileRequestContext profileRequestContext) {
        AttributeConsumingServiceContext acsCtx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SAMLMetadataContext metadataContext = (SAMLMetadataContext)this.metadataContextLookupStrategy.apply((Object)profileRequestContext);
        if (null == metadataContext) {
            return false;
        }
        this.entityDescriptor = metadataContext.getEntityDescriptor();
        if (null == this.entityDescriptor) {
            return false;
        }
        RoleDescriptor roleDescriptor = metadataContext.getRoleDescriptor();
        if (roleDescriptor instanceof SPSSODescriptor) {
            this.spSSODescriptor = (SPSSODescriptor)roleDescriptor;
        }
        if (null != (acsCtx = (AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class))) {
            this.acsDesriptor = acsCtx.getAttributeConsumingService();
        }
        return true;
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        this.rpUIContext = (RelyingPartyUIContext)((Object)this.rpUIContextCreateStrategy.apply((Object)profileRequestContext));
        if (this.rpUIContext == null) {
            this.log.error("{} Unable to create RelyingPartyUIContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        if (null != this.fallbackLanguages) {
            this.rpUIContext.setFallbackLanguages(this.fallbackLanguages);
        }
        this.rpUIContext.setRPEntityDescriptor(this.entityDescriptor);
        this.rpUIContext.setRPSPSSODescriptor(this.spSSODescriptor);
        this.rpUIContext.setRPAttributeConsumingService(this.acsDesriptor);
        this.rpUIContext.setRPUInfo(this.getRPUInfo());
        this.rpUIContext.setBrowserLanguages(this.getBrowserLanguages());
    }
}

