/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContactTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5437171915434315671L;
    private static Logger log = LoggerFactory.getLogger(ServiceContactTag.class);
    private ContactPersonTypeEnumeration contactType = ContactPersonTypeEnumeration.SUPPORT;
    private String contactName;

    public void setContactType(@Nullable String type) {
        if (null == type || 0 == type.length()) {
            log.warn("no parameter provided to contactType");
            return;
        }
        if (type.equals(ContactPersonTypeEnumeration.ADMINISTRATIVE)) {
            this.contactType = ContactPersonTypeEnumeration.ADMINISTRATIVE;
        } else if (type.equals(ContactPersonTypeEnumeration.BILLING)) {
            this.contactType = ContactPersonTypeEnumeration.BILLING;
        } else if (type.equals(ContactPersonTypeEnumeration.OTHER)) {
            this.contactType = ContactPersonTypeEnumeration.OTHER;
        } else if (type.equals(ContactPersonTypeEnumeration.SUPPORT)) {
            this.contactType = ContactPersonTypeEnumeration.SUPPORT;
        } else if (type.equals(ContactPersonTypeEnumeration.TECHNICAL)) {
            this.contactType = ContactPersonTypeEnumeration.TECHNICAL;
        } else {
            log.warn("parameter provided to contactType:" + type + " is invalid");
            return;
        }
    }

    public void setName(@Nullable String name) {
        this.contactName = name;
    }

    @Nullable
    private String buildURL(@Nullable String email, @Nullable String name) {
        if (null != email) {
            log.debug("constructing hyperlink from name '{}' and email '{}'", (Object)name, (Object)email);
            return this.buildHyperLink(email, name);
        }
        log.debug("no email found, using name '{}' with no hyperlink", (Object)name);
        if (null == name) {
            return name;
        }
        return HTMLEncoder.encodeForHTML((String)name);
    }

    @Nullable
    private String getStringFromContact(ContactPerson contact) {
        List emails = contact.getEmailAddresses();
        String emailAddress = null;
        if (emails != null && !emails.isEmpty()) {
            emailAddress = ((EmailAddress)emails.get(0)).getAddress();
        }
        if (null != this.contactName) {
            return this.buildURL(emailAddress, this.contactName);
        }
        SurName surName = contact.getSurName();
        GivenName givenName = contact.getGivenName();
        StringBuilder fullName = new StringBuilder();
        if (null != givenName) {
            fullName.append(givenName.getName()).append(" ");
        }
        if (null != surName) {
            fullName.append(surName.getName()).append(" ");
        }
        if (0 == fullName.length()) {
            if (null == emails) {
                log.debug("No name and no email");
                return null;
            }
            log.debug("no names found, using email address as text");
            fullName.append(emailAddress);
        }
        return this.buildURL(emailAddress, fullName.toString());
    }

    @Nullable
    protected String getContactFromEntity() {
        if (this.getRelyingPartyUIContext() == null) {
            return null;
        }
        ContactPerson contact = this.getRelyingPartyUIContext().getContactPerson(this.contactType);
        if (null == contact) {
            return null;
        }
        return this.getStringFromContact(contact);
    }

    public int doEndTag() throws JspException {
        String result = this.getContactFromEntity();
        try {
            if (null == result) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating contact");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

