/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.context;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.saml.metadata.ACSUIInfo;
import net.shibboleth.idp.saml.metadata.IdPUIInfo;
import net.shibboleth.idp.saml.metadata.OrganizationUIInfo;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelyingPartyUIContext
extends BaseContext {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartyUIContext.class);
    @Nullable
    private EntityDescriptor rpEntityDescriptor;
    @Nullable
    private SPSSODescriptor rpSPSSODescriptor;
    @Nullable
    private ACSUIInfo rpACSUIinfo;
    @Nullable
    private IdPUIInfo rpUIInfo;
    @Nullable
    @NonnullElements
    private List<Locale.LanguageRange> browserLanguages = Collections.emptyList();
    @Nonnull
    private List<Locale.LanguageRange> fallbackLanguages = Collections.emptyList();
    @Nullable
    private Supplier<HttpServletRequest> requestSupplier;

    @Nullable
    protected EntityDescriptor getRPEntityDescriptor() {
        return this.rpEntityDescriptor;
    }

    @Nonnull
    public RelyingPartyUIContext setRPEntityDescriptor(@Nullable EntityDescriptor what) {
        this.rpEntityDescriptor = what;
        return this;
    }

    @Nullable
    protected SPSSODescriptor getRPSPSSODescriptor() {
        return this.rpSPSSODescriptor;
    }

    @Nonnull
    public RelyingPartyUIContext setRPSPSSODescriptor(@Nullable SPSSODescriptor what) {
        this.rpSPSSODescriptor = what;
        return this;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getEntityAttributeStringValues(@Nonnull @NotEmpty String id) {
        EntityDescriptor object = this.getRPEntityDescriptor();
        if (object == null) {
            return Collections.emptyList();
        }
        ArrayList accumulator = new ArrayList();
        while (object != null) {
            object.getObjectMetadata().get(AttributesMapContainer.class).forEach(c -> accumulator.addAll(c.getStringValues(id)));
            object = object.getParent();
        }
        return List.copyOf(accumulator);
    }

    @Nullable
    protected ACSUIInfo getRPACSUInfo() {
        return this.rpACSUIinfo;
    }

    @Nullable
    protected IdPUIInfo getRPUInfo() {
        return this.rpUIInfo;
    }

    @Nonnull
    public RelyingPartyUIContext setRPUInfo(@Nullable UIInfo what) {
        if (what == null) {
            return this;
        }
        List list = what.getObjectMetadata().get(IdPUIInfo.class);
        this.rpUIInfo = list.isEmpty() ? new IdPUIInfo(what) : (IdPUIInfo)list.get(0);
        return this;
    }

    @Nonnull
    public RelyingPartyUIContext setRPAttributeConsumingService(@Nullable AttributeConsumingService what) {
        if (what == null) {
            return this;
        }
        List list = what.getObjectMetadata().get(ACSUIInfo.class);
        this.rpACSUIinfo = list.isEmpty() ? new ACSUIInfo(what) : (ACSUIInfo)list.get(0);
        return this;
    }

    public RelyingPartyUIContext setRequestSupplier(@Nonnull Supplier<HttpServletRequest> what) {
        this.requestSupplier = what;
        return this;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    public RelyingPartyUIContext setBrowserLanguages(@Nonnull @NonnullElements List<String> languages) {
        Constraint.isNotNull(languages, (String)"Language List cannot be null");
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"RelyingPartyUIContext.setBrowserLanguages", null, (String)"setBrowserLanguageRanges");
        this.browserLanguages = languages.stream().filter(e -> e != null).map(s -> new Locale.LanguageRange((String)s)).collect(Collectors.toUnmodifiableList());
        return this;
    }

    @Nonnull
    public RelyingPartyUIContext setBrowserLanguageRanges(@Nonnull @NonnullElements List<Locale.LanguageRange> ranges) {
        this.browserLanguages = (List)Constraint.isNotNull(ranges, (String)"Language Range cannot be null");
        return this;
    }

    @Nonnull
    @NonnullElements
    protected List<Locale.LanguageRange> getBrowserLanguages() {
        if (this.requestSupplier == null || this.requestSupplier.get() == null) {
            return this.browserLanguages;
        }
        return SpringSupport.getLanguageRange((HttpServletRequest)this.requestSupplier.get());
    }

    @Nonnull
    public RelyingPartyUIContext setFallbackLanguages(@Nullable List<String> languages) {
        if (languages == null || languages.isEmpty()) {
            this.fallbackLanguages = Collections.emptyList();
        }
        this.fallbackLanguages = languages.stream().filter(s -> s != null).map(s -> new Locale.LanguageRange((String)s)).collect(Collectors.toUnmodifiableList());
        return this;
    }

    @Nonnull
    @NonnullElements
    protected List<Locale.LanguageRange> getFallbackLanguages() {
        return this.fallbackLanguages;
    }

    @Nullable
    private String policeURL(@Nullable String url, @Nonnull @NotEmpty List<String> acceptableSchemes) {
        if (null == url) {
            this.log.trace("Empty Value - returning null");
            return null;
        }
        try {
            String scheme = new URI(url).getScheme();
            for (String acceptableScheme : acceptableSchemes) {
                if (!acceptableScheme.equals(scheme)) continue;
                this.log.debug("Acceptable Scheme '{}', returning value '{}'", (Object)acceptableScheme, (Object)url);
                return url;
            }
            this.log.warn("The logo URL '{}' contained an invalid scheme (expected '{}'), returning null", (Object)url, acceptableSchemes);
            return null;
        }
        catch (URISyntaxException e) {
            this.log.warn("The logo URL '{}' contained was not a URL, returning null", (Object)url);
            return null;
        }
    }

    @Nullable
    protected String policeURLLogo(@Nullable String url) {
        return this.policeURL(url, Arrays.asList("http", "https", "data"));
    }

    @Nullable
    protected String policeURLNonLogo(@Nullable String url) {
        return this.policeURL(url, Arrays.asList("http", "https", "mailto"));
    }

    @Nullable
    protected String getNameFromAttributeConsumingService() {
        ACSUIInfo acsInfo = this.getRPACSUInfo();
        if (null == acsInfo) {
            this.log.debug("No ACS so no ServiceName");
            return null;
        }
        Map serviceNames = acsInfo.getServiceNames();
        Locale l = Locale.lookup(this.getBrowserLanguages(), serviceNames.keySet());
        if (l == null) {
            l = Locale.lookup(this.getFallbackLanguages(), serviceNames.keySet());
        }
        if (l != null) {
            this.log.debug("Found ServiceName '{}' in ACS, locale '{}'", serviceNames.get(l), (Object)l);
            return (String)serviceNames.get(l);
        }
        this.log.debug("No ServiceName in ACS for '{}' or '{}'", this.getBrowserLanguages(), this.getFallbackLanguages());
        return null;
    }

    @Nullable
    protected String getNameFromEntityId() {
        if (null == this.getRPEntityDescriptor()) {
            this.log.trace("No relying party, no Name");
            return null;
        }
        String spName = this.getRPEntityDescriptor().getEntityID();
        try {
            URI entityId = new URI(spName);
            String scheme = entityId.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                this.log.debug("Found matching scheme, returning name of '{}'", (Object)entityId.getHost());
                return entityId.getHost();
            }
            this.log.debug("Not a usual scheme, returning name of '{}'", (Object)spName);
            return spName;
        }
        catch (URISyntaxException e) {
            this.log.debug("Not a URI, returning name of '{}'", (Object)spName);
            return spName;
        }
    }

    @Nullable
    protected String getDescriptionFromUIInfo() {
        IdPUIInfo info = this.getRPUInfo();
        if (info == null) {
            this.log.warn("GetDescription: No UIInfo");
            return null;
        }
        Map descriptions = this.getRPUInfo().getDescriptions();
        Locale l = Locale.lookup(this.getBrowserLanguages(), descriptions.keySet());
        if (l == null) {
            l = Locale.lookup(this.getFallbackLanguages(), descriptions.keySet());
        }
        if (l != null) {
            this.log.debug("Found Description '{}' in UIInfo, locale '{}'", descriptions.get(l), (Object)l);
            return (String)descriptions.get(l);
        }
        this.log.debug("No Description in UIINFO for '{}' or '{}'", this.getBrowserLanguages(), this.getFallbackLanguages());
        return null;
    }

    @Nullable
    protected String getDescriptionFromAttributeConsumingService(String lang) {
        ACSUIInfo acsInfo = this.getRPACSUInfo();
        if (null == acsInfo) {
            this.log.debug("No ACS so no ServiceDescription");
            return null;
        }
        Map serviceDescriptions = acsInfo.getServiceDescriptions();
        Locale l = Locale.lookup(this.getBrowserLanguages(), serviceDescriptions.keySet());
        if (l == null) {
            l = Locale.lookup(this.getFallbackLanguages(), serviceDescriptions.keySet());
        }
        if (l != null) {
            this.log.debug("Found ServiceDescription '{}' in ACS, locale '{}'", serviceDescriptions.get(l), (Object)l);
            return (String)serviceDescriptions.get(l);
        }
        this.log.debug("No ServiceDescription in ACS for '{}' or '{}'", this.getBrowserLanguages(), this.getFallbackLanguages());
        return null;
    }

    @Nullable
    protected OrganizationUIInfo getOrganization() {
        Organization organization = null;
        if (null != this.getRPSPSSODescriptor()) {
            organization = this.getRPSPSSODescriptor().getOrganization();
        }
        if (organization == null && this.getRPEntityDescriptor() != null) {
            organization = this.getRPEntityDescriptor().getOrganization();
        }
        if (organization == null) {
            return null;
        }
        List infoList = organization.getObjectMetadata().get(OrganizationUIInfo.class);
        if (infoList.isEmpty()) {
            return new OrganizationUIInfo(organization);
        }
        return (OrganizationUIInfo)infoList.get(0);
    }

    protected ContactPersonTypeEnumeration getContactType(@Nullable String type) {
        String value = StringSupport.trimOrNull((String)type);
        if (null == value) {
            this.log.warn("no parameter provided to contactType");
            return ContactPersonTypeEnumeration.SUPPORT;
        }
        if (type.equals(ContactPersonTypeEnumeration.ADMINISTRATIVE.toString())) {
            return ContactPersonTypeEnumeration.ADMINISTRATIVE;
        }
        if (type.equals(ContactPersonTypeEnumeration.BILLING.toString())) {
            return ContactPersonTypeEnumeration.BILLING;
        }
        if (type.equals(ContactPersonTypeEnumeration.OTHER.toString())) {
            return ContactPersonTypeEnumeration.OTHER;
        }
        if (type.equals(ContactPersonTypeEnumeration.SUPPORT.toString())) {
            return ContactPersonTypeEnumeration.SUPPORT;
        }
        if (type.equals(ContactPersonTypeEnumeration.TECHNICAL.toString())) {
            return ContactPersonTypeEnumeration.TECHNICAL;
        }
        this.log.warn("parameter provided to contactType: " + type + " is invalid");
        return ContactPersonTypeEnumeration.SUPPORT;
    }

    @Nullable
    public ContactPerson getContactPerson(ContactPersonTypeEnumeration contactType) {
        if (null == this.getRPEntityDescriptor()) {
            return null;
        }
        List contacts = this.getRPEntityDescriptor().getContactPersons();
        if (null == contacts || contacts.isEmpty()) {
            this.log.trace("No Contacts found at all");
            return null;
        }
        for (ContactPerson contact : contacts) {
            if (contactType != contact.getType()) continue;
            return contact;
        }
        this.log.trace("No matching Contacts found at all");
        return null;
    }

    @Nullable
    public String getServiceName() {
        IdPUIInfo uiinfo = this.getRPUInfo();
        ACSUIInfo acsinfo = this.getRPACSUInfo();
        Locale l = null;
        Map names = null;
        this.log.trace("GetServiceName - looking browser Locales '{}', Falllback locales '{}'");
        if (uiinfo != null) {
            this.log.trace("Looking in UI info for Browser Locales");
            names = uiinfo.getDisplayNames();
            l = Locale.lookup(this.getBrowserLanguages(), names.keySet());
        }
        if (l == null && acsinfo != null) {
            this.log.trace("Looking in ACS for Browser Locales");
            names = acsinfo.getServiceNames();
            l = Locale.lookup(this.getBrowserLanguages(), names.keySet());
        }
        if (l == null && uiinfo != null) {
            this.log.trace("Looking in UI info for Fallback Locales");
            names = uiinfo.getDisplayNames();
            l = Locale.lookup(this.getFallbackLanguages(), names.keySet());
        }
        if (l == null && acsinfo != null) {
            this.log.trace("Looking in ACS for Fallback Locales");
            names = acsinfo.getServiceNames();
            l = Locale.lookup(this.getFallbackLanguages(), names.keySet());
        }
        if (l != null) {
            String result = (String)names.get(l);
            this.log.debug("Found Name '{}' for Locale '{}'", (Object)result, (Object)l);
            return result;
        }
        this.log.debug("Nothing found returning name from entity");
        return this.getNameFromEntityId();
    }

    @Nullable
    public String getServiceDescription() {
        IdPUIInfo uiinfo = this.getRPUInfo();
        ACSUIInfo acsinfo = this.getRPACSUInfo();
        Locale l = null;
        Map names = null;
        this.log.trace("GetServiceDescription - looking browser Locales '{}', Falllback locales '{}'");
        if (uiinfo != null) {
            this.log.trace("Looking in UI info for Browser Locales");
            names = uiinfo.getDescriptions();
            l = Locale.lookup(this.getBrowserLanguages(), names.keySet());
        }
        if (l == null && acsinfo != null) {
            this.log.trace("Looking in ACS for Browser Locales");
            names = acsinfo.getServiceDescriptions();
            l = Locale.lookup(this.getBrowserLanguages(), names.keySet());
        }
        if (l == null && uiinfo != null) {
            this.log.trace("Looking in UI info for Fallback Locales");
            names = uiinfo.getDescriptions();
            l = Locale.lookup(this.getFallbackLanguages(), names.keySet());
        }
        if (l == null && acsinfo != null) {
            this.log.trace("Looking in ACS for Fallback Locales");
            names = acsinfo.getServiceDescriptions();
            l = Locale.lookup(this.getFallbackLanguages(), names.keySet());
        }
        if (l != null) {
            String result = (String)names.get(l);
            this.log.debug("Found Name '{}' for Locale '{}'", (Object)result, (Object)l);
            return result;
        }
        this.log.debug("Nothing found");
        return null;
    }

    @Nullable
    public String getOrganizationDisplayName() {
        OrganizationUIInfo org = this.getOrganization();
        if (null == org) {
            this.log.debug("No Organization, returning null");
            return null;
        }
        return this.getLocalizeString(org.getOrganizationDisplayNames(), "OrganizationDisplayName");
    }

    @Nullable
    public String getOrganizationName() {
        OrganizationUIInfo org = this.getOrganization();
        if (null == org) {
            this.log.debug("No Organization, returning null");
            return null;
        }
        return this.getLocalizeString(org.getOrganizationNames(), "OrganizationName");
    }

    public String getOrganizationURL() {
        OrganizationUIInfo org = this.getOrganization();
        if (null == org) {
            this.log.debug("No Organization, returning null");
            return null;
        }
        return this.policeURLNonLogo(this.getLocalizeString(org.getOrganizationUrls(), "OrganizationURLs"));
    }

    @Nullable
    public String getContactSurName(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getSurName()) {
            return null;
        }
        return contact.getSurName().getValue();
    }

    @Nullable
    public String getContactGivenName(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getGivenName()) {
            return null;
        }
        return contact.getGivenName().getValue();
    }

    @Nullable
    public String getContactEmail(@Nullable String contactType) {
        ContactPerson contact = this.getContactPerson(this.getContactType(contactType));
        if (null == contact || null == contact.getEmailAddresses() || contact.getEmailAddresses().isEmpty()) {
            return null;
        }
        return this.policeURLNonLogo(((EmailAddress)contact.getEmailAddresses().get(0)).getURI());
    }

    @Nullable
    private String getLocalizeString(@Nonnull Map<Locale, String> map, @Nonnull String type) {
        if (null == map || map.isEmpty()) {
            this.log.debug("No {}s returning null", (Object)type);
            return null;
        }
        Locale l = Locale.lookup(this.getBrowserLanguages(), map.keySet());
        if (l == null) {
            this.log.trace("No {} found from Brower langages '{}' in '{}'", new Object[]{type, this.getBrowserLanguages(), map.keySet()});
            l = Locale.lookup(this.getFallbackLanguages(), map.keySet());
        }
        if (l == null) {
            this.log.debug("No relevant {} with language match, returning null", (Object)type);
            return null;
        }
        String result = map.get(l);
        this.log.debug("Found {} '{}' for '{}'", new Object[]{type, result, l});
        return result;
    }

    @Nullable
    public String getInformationURL() {
        if (null == this.getRPUInfo()) {
            this.log.debug("No UIInfo returning null");
            return null;
        }
        return this.policeURLNonLogo(this.getLocalizeString(this.getRPUInfo().getInformationURLs(), "InformationURL"));
    }

    @Nullable
    public String getPrivacyStatementURL() {
        if (null == this.getRPUInfo()) {
            this.log.debug("No UIInfo returning null");
            return null;
        }
        return this.policeURLNonLogo(this.getLocalizeString(this.getRPUInfo().getPrivacyStatementURLs(), "PrivacyStatementURL"));
    }

    private boolean logoFits(Logo logo, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        int width;
        int height;
        if (null == logo.getHeight()) {
            this.log.warn("No height available for {} assuming a fit", (Object)logo.getURI());
            height = maxHeight - 1;
        } else {
            height = logo.getHeight();
        }
        if (null == logo.getWidth()) {
            this.log.warn("No width available for {} assuming a fit", (Object)logo.getURI());
            width = maxWidth - 1;
        } else {
            width = logo.getWidth();
        }
        return height <= maxHeight && height >= minHeight && width <= maxWidth && width >= minWidth;
    }

    @Nullable
    public String getLogo(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        if (null == this.getRPUInfo()) {
            this.log.debug("No UIInfo or logos returning null");
            return null;
        }
        Map logos = this.getRPUInfo().getLocaleLogos();
        if (logos != null && !logos.isEmpty()) {
            String result;
            for (Locale l : Locale.filter(this.getBrowserLanguages(), logos.keySet())) {
                for (Logo logo : (List)logos.get(l)) {
                    this.log.trace("Found logo in UIInfo, ({} x {}) - {}", new Object[]{logo.getWidth(), logo.getHeight(), l});
                    if (!this.logoFits(logo, minWidth, minHeight, maxWidth, maxHeight) || (result = this.policeURLLogo(logo.getURI())) == null) continue;
                    this.log.debug("Found locale logo from UIInfo, ({} x {}) : {}", new Object[]{logo.getWidth(), logo.getHeight(), result});
                    return result;
                }
            }
            for (Locale l : Locale.filter(this.getFallbackLanguages(), logos.keySet())) {
                for (Logo logo : (List)logos.get(l)) {
                    this.log.trace("Found logo in UIInfo, ({} x {}) - {}", new Object[]{logo.getWidth(), logo.getHeight(), l});
                    if (!this.logoFits(logo, minWidth, minHeight, maxWidth, maxHeight) || (result = this.policeURLLogo(logo.getURI())) == null) continue;
                    this.log.debug("Found locale logo from UIInfo, ({} x {}) : {}", new Object[]{logo.getWidth(), logo.getHeight(), result});
                    return result;
                }
            }
        }
        for (Logo logo : this.rpUIInfo.getNonLocaleLogos()) {
            this.log.trace("Found logo in UIInfo, ({} x {})", (Object)logo.getWidth(), (Object)logo.getHeight());
            if (!this.logoFits(logo, minWidth, minHeight, maxWidth, maxHeight)) {
                this.log.trace("Size Mismatch");
                continue;
            }
            String result = this.policeURLLogo(logo.getURI());
            if (result == null) continue;
            this.log.debug("Found nonlocale logo from UIInfo, ({} x {}) : {}", new Object[]{logo.getWidth(), logo.getHeight(), logo.getURI()});
            return result;
        }
        this.log.debug("No valid logos which fit found");
        return null;
    }

    @Nullable
    public String getLogo(String minWidth, String minHeight, String maxWidth, String maxHeight) {
        int maxH;
        int maxW;
        int minH;
        int minW;
        try {
            minW = Integer.parseInt(minWidth);
        }
        catch (NumberFormatException ex) {
            minW = Integer.MIN_VALUE;
        }
        try {
            minH = Integer.parseInt(minHeight);
        }
        catch (NumberFormatException ex) {
            minH = Integer.MIN_VALUE;
        }
        try {
            maxW = Integer.parseInt(maxWidth);
        }
        catch (NumberFormatException ex) {
            maxW = Integer.MAX_VALUE;
        }
        try {
            maxH = Integer.parseInt(maxHeight);
        }
        catch (NumberFormatException ex) {
            maxH = Integer.MAX_VALUE;
        }
        return this.getLogo(minW, minH, maxW, maxH);
    }

    @Nullable
    public String getLogo() {
        return this.getLogo(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

