/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5633365955540356312L;
    private static Logger log = LoggerFactory.getLogger(OrganizationURLTag.class);
    private static String linkText;

    public void setLinkText(String text) {
        linkText = text;
    }

    @Nullable
    private String getOrganizationURL() {
        if (this.getRelyingPartyUIContext() == null) {
            return null;
        }
        return this.getRelyingPartyUIContext().getOrganizationURL();
    }

    public int doEndTag() throws JspException {
        String orgURL = this.getOrganizationURL();
        try {
            if (null == orgURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(orgURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating OrganizationURL: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

